/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.utils.RedisUtils;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.util.SafeEncoder;

public class ClusteredApiService
implements RedisAPIService {
    private final ExecutableRedisConnection<JedisCluster> connection;

    public ClusteredApiService(ExecutableRedisConnection<JedisCluster> connection) {
        this.connection = connection;
    }

    @Override
    public Long setnx(String key, byte[] value) {
        return this.connection.executeExpectingResponse(cluster -> cluster.setnx(SafeEncoder.encode((String)key), value));
    }

    @Override
    public String set(String key, String value, Integer entryTTL, boolean ifNotExists) {
        String usedValue = Optional.ofNullable(value).orElse("");
        String result = this.connection.executeExpectingResponse(ifNotExists ? jedisCommands -> Optional.ofNullable(jedisCommands.setnx(key, usedValue)).map(Long::intValue).orElse(0) == 1 ? "OK" : null : jedisCommands -> jedisCommands.set(key, usedValue));
        Optional.ofNullable(entryTTL).ifPresent(ttl -> this.expire(key, (int)ttl));
        return result;
    }

    @Override
    public byte[] set(String key, byte[] value, Integer entryTTL, boolean ifNotExists) {
        return this.connection.executeExpectingResponse(cluster -> {
            String result = null;
            if (ifNotExists) {
                if (this.setnx(key, value) == 0L) {
                    result = null;
                }
            } else {
                result = cluster.set(SafeEncoder.encode((String)key), value);
            }
            if (entryTTL != null) {
                this.expire(key, entryTTL);
            }
            if (result != null) {
                return result.getBytes();
            }
            return null;
        });
    }

    @Override
    public Long expire(String key, int seconds) {
        return this.connection.executeExpectingResponse(cluster -> cluster.expire(SafeEncoder.encode((String)key), seconds));
    }

    @Override
    public byte[] get(String key) {
        return this.connection.execute(cluster -> cluster.get(SafeEncoder.encode((String)key)));
    }

    @Override
    public boolean exists(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.exists(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long incr(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.incr(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long incrBy(String key, long integer) {
        return this.connection.executeExpectingResponse(cluster -> cluster.incrBy(SafeEncoder.encode((String)key), integer));
    }

    @Override
    public Long decr(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.decr(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long decrBy(String key, long integer) {
        return this.connection.executeExpectingResponse(cluster -> cluster.decrBy(SafeEncoder.encode((String)key), integer));
    }

    @Override
    public Long hsetnx(String key, byte[] field, byte[] value) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hsetnx(SafeEncoder.encode((String)key), field, value));
    }

    @Override
    public Long hset(String key, String value, String field, boolean ifNotExists) {
        return this.connection.executeExpectingResponse(cluster -> {
            Long response = null;
            byte[] fieldAsBytes = SafeEncoder.encode((String)field);
            byte[] valueAsBytes = RedisUtils.toUTF8Bytes(value);
            response = ifNotExists ? cluster.hsetnx(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes) : cluster.hset(SafeEncoder.encode((String)key), fieldAsBytes, valueAsBytes);
            return response;
        });
    }

    @Override
    public byte[] hget(String key, String field) {
        return this.connection.execute(cluster -> cluster.hget(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field)));
    }

    @Override
    public Map<String, String> hgetAll(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hgetAll(key));
    }

    @Override
    public Long hincrBy(String key, String field, long value) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hincrBy(SafeEncoder.encode((String)key), SafeEncoder.encode((String)field), value));
    }

    @Override
    public Set<byte[]> hkeys(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hkeys(SafeEncoder.encode((String)key)));
    }

    @Override
    public Set<byte[]> keys(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hkeys(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long del(String ... keys) {
        return this.connection.executeExpectingResponse(cluster -> cluster.del(keys));
    }

    @Override
    public byte[] rpop(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.rpop(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long lpushx(String key, String string) {
        return this.connection.executeExpectingResponse(cluster -> cluster.lpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long lpush(String key, String string) {
        return this.connection.executeExpectingResponse(cluster -> cluster.lpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long sadd(String key, byte[] string) {
        return this.connection.executeExpectingResponse(cluster -> cluster.sadd(SafeEncoder.encode((String)key), (byte[][])new byte[][]{string}));
    }

    @Override
    public byte[] spop(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.spop(SafeEncoder.encode((String)key)));
    }

    @Override
    public byte[] srandmember(String key) {
        return this.connection.execute(cluster -> cluster.srandmember(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long zadd(String key, double score, byte[] member) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zadd(SafeEncoder.encode((String)key), score, member));
    }

    @Override
    public byte[] lpop(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.lpop(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long rpushx(String key, String string) {
        return this.connection.executeExpectingResponse(cluster -> cluster.rpushx(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Long rpush(String key, String string) {
        return this.connection.executeExpectingResponse(cluster -> cluster.rpush(SafeEncoder.encode((String)key), (byte[][])new byte[][]{RedisUtils.toUTF8Bytes(string)}));
    }

    @Override
    public Set<byte[]> zrange(String key, long start, long end) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zrange(SafeEncoder.encode((String)key), start, end));
    }

    @Override
    public Set<byte[]> zrangeByScore(String key, double min, double max) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zrangeByScore(SafeEncoder.encode((String)key), min, max));
    }

    @Override
    public Set<byte[]> zrevrange(String key, long start, long end) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zrevrange(SafeEncoder.encode((String)key), start, end));
    }

    @Override
    public Set<byte[]> zrevrangeByScore(String key, double max, double min) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zrevrangeByScore(SafeEncoder.encode((String)key), max, min));
    }

    @Override
    public Double zincrby(String key, double score, String member) {
        return this.connection.executeExpectingResponse(cluster -> cluster.zincrby(SafeEncoder.encode((String)key), score, RedisUtils.toUTF8Bytes(member)));
    }

    @Override
    public Long expireAt(String key, long unixTime) {
        return this.connection.executeExpectingResponse(cluster -> cluster.expireAt(SafeEncoder.encode((String)key), unixTime));
    }

    @Override
    public Long persist(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.persist(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long ttl(String key) {
        return this.connection.executeExpectingResponse(cluster -> cluster.ttl(SafeEncoder.encode((String)key)));
    }

    @Override
    public Long publish(String channel, String message) {
        return this.connection.executeExpectingResponse(cluster -> cluster.publish(channel, message));
    }

    @Override
    public boolean hexists(String key, byte[] field) {
        return this.connection.executeExpectingResponse(cluster -> cluster.hexists(SafeEncoder.encode((String)key), field));
    }

    @Override
    public String ltrim(String key, long start, long stop) {
        return this.connection.executeExpectingResponse(cluster -> cluster.ltrim(SafeEncoder.encode((String)key), start, stop));
    }

    @Override
    public List<String> lrange(String key, long start, long stop) {
        return this.connection.executeExpectingResponse(cluster -> cluster.lrange(SafeEncoder.encode((String)key), start, stop)).stream().map(i -> SafeEncoder.encode((byte[])i)).collect(Collectors.toList());
    }
}

