/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.operation;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.extension.redis.internal.connection.RedisConnection;
import org.mule.extension.redis.internal.error.exceptions.RedisOperationErrorTypeProvider;
import org.mule.extension.redis.internal.service.RedisAPIService;
import org.mule.extension.redis.internal.service.factory.ServiceFactory;
import org.mule.extension.redis.internal.utils.RedisUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import redis.clients.jedis.util.SafeEncoder;

public class RedisOperations {
    private ServiceFactory serviceFactory = new ServiceFactory();

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String set(@Connection RedisConnection connection, String key, @Content String value, @Optional Integer expire, @Optional boolean ifNotExists) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.set(key, value, expire != null ? expire : connection.getEntryTTL(), ifNotExists);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String get(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] bytes = redisApiService.get(key);
        return bytes == null ? null : SafeEncoder.encode((byte[])bytes);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public boolean exists(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.exists(key);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Long increment(@Connection RedisConnection connection, String key, @Optional(defaultValue="1") long step) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return step == 1L ? redisApiService.incr(key) : redisApiService.incrBy(key, step);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Long decrement(@Connection RedisConnection connection, String key, @Optional(defaultValue="1") long step) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return step == 1L ? redisApiService.decr(key) : redisApiService.decrBy(key, step);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String setInHash(@Connection RedisConnection connection, String key, @Content String value, @Optional String field, @Optional boolean ifNotExists) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.hset(key, value, field, ifNotExists) == null ? null : value;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String getFromHash(@Connection RedisConnection connection, String key, String field) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] hget = redisApiService.hget(key, field);
        return hget == null ? null : SafeEncoder.encode((byte[])hget);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Long incrementHash(@Connection RedisConnection connection, String key, String field, @Optional(defaultValue="1") long step) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.hincrBy(key, field, step);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String pushToList(@Connection RedisConnection connection, String key, @Content String value, boolean pushLeft, @Optional boolean ifExists) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] push = RedisUtils.toUTF8Bytes(value);
        if (pushLeft) {
            if (ifExists) {
                if (redisApiService.lpushx(key, value) == 0L) {
                    push = null;
                }
            } else {
                redisApiService.lpush(key, value);
            }
        } else if (ifExists) {
            if (redisApiService.rpushx(key, value) == 0L) {
                push = null;
            }
        } else {
            redisApiService.rpush(key, value);
        }
        return SafeEncoder.encode((byte[])push);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String popFromList(@Connection RedisConnection connection, String key, boolean popLeft) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] pop = popLeft ? redisApiService.lpop(key) : redisApiService.rpop(key);
        return SafeEncoder.encode((byte[])pop);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="text/plain")
    public String trimFromList(@Connection RedisConnection connection, String key, long start, long stop) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.ltrim(key, start, stop);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public List<String> rangeFromList(@Connection RedisConnection connection, String key, long start, long stop) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.lrange(key, start, stop);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String addToSet(@Connection RedisConnection connection, String key, @Content String value, @Optional boolean mustSucceed) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] valueAsBytes = RedisUtils.toUTF8Bytes(value);
        long result = redisApiService.sadd(key, valueAsBytes);
        return !mustSucceed || result > 0L ? value : null;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String popFromSet(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] spop = redisApiService.spop(key);
        return SafeEncoder.encode((byte[])spop);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String randomMemberFromSet(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] srandmember = redisApiService.srandmember(key);
        return srandmember == null ? null : SafeEncoder.encode((byte[])srandmember);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String addToSortedSet(@Connection RedisConnection connection, String key, @Content String value, double score, @Optional boolean mustSucceed) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        byte[] valueAsBytes = RedisUtils.toUTF8Bytes(value);
        long result = redisApiService.zadd(key, score, valueAsBytes);
        return !mustSucceed || result > 0L ? value : null;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Set<String> getRangeByIndex(@Connection RedisConnection connection, String key, int start, int end, @Optional(defaultValue="true") boolean ascendingOrder) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        Set<byte[]> rangeByIndex = null;
        rangeByIndex = ascendingOrder ? redisApiService.zrange(key, start, end) : redisApiService.zrevrange(key, start, end);
        return rangeByIndex.stream().map(bytes -> new String((byte[])bytes)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Set<String> getRangeByScore(@Connection RedisConnection connection, String key, double min, double max, @Optional(defaultValue="true") boolean ascendingOrder) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        Set<byte[]> rangeByScore = ascendingOrder ? redisApiService.zrangeByScore(key, min, max) : redisApiService.zrevrangeByScore(key, min, max);
        return rangeByScore.stream().map(bytes -> new String((byte[])bytes)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Double incrementSortedSet(@Connection RedisConnection connection, String key, @Content String value, double step) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.zincrby(key, step, value);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Long getTtl(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.ttl(key);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public boolean persist(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.persist(key) == 1L;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Long del(@Connection RedisConnection connection, String key) {
        RedisAPIService redisApiService = this.serviceFactory.getService(connection);
        return redisApiService.del(key);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public boolean expireAt(@Connection RedisConnection connection, String key, long unixTime) {
        RedisAPIService redisAPIService = this.serviceFactory.getService(connection);
        return redisAPIService.expireAt(key, unixTime) == 1L;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public Map<String, String> getAllFromHash(@Connection RedisConnection connection, String key) {
        RedisAPIService redisAPIService = this.serviceFactory.getService(connection);
        return redisAPIService.hgetAll(key);
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public boolean expire(@Connection RedisConnection connection, String key, int seconds) {
        RedisAPIService redisAPIService = this.serviceFactory.getService(connection);
        return redisAPIService.expire(key, seconds) == 1L;
    }

    @Throws(value={RedisOperationErrorTypeProvider.class})
    public boolean publish(@Connection RedisConnection connection, String channel, String message) {
        RedisAPIService redisAPIService = this.serviceFactory.getService(connection);
        return redisAPIService.publish(channel, message) == 1L;
    }
}

