/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.connection.RedisPoolConnection;
import org.mule.extension.redis.internal.connection.param.SentinelConnectionParams;
import org.mule.extension.redis.internal.connection.provider.RedisConnectionProvider;
import org.mule.extension.redis.internal.error.exceptions.InvalidDatabaseIndexException;
import org.mule.extension.redis.internal.error.exceptions.InvalidMasterNameException;
import org.mule.extension.redis.internal.stereotype.ObjectStoreConnectionStereotype;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

@Alias(value="sentinel")
@DisplayName(value="Sentinel")
@Stereotype(value=ObjectStoreConnectionStereotype.class)
public class SentinelConnectionProvider
extends RedisConnectionProvider<ExecutableRedisConnection>
implements CachedConnectionProvider<ExecutableRedisConnection> {
    private static final Logger logger = LoggerFactory.getLogger(SentinelConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private SentinelConnectionParams sentinelConnectionParams;
    private static Pattern p = Pattern.compile("^[a-zA-Z0-9_.-]+", 2);

    public void initialise() throws InitialisationException {
        if (this.sentinelConnectionParams.getMasterName() != null && !p.matcher(this.sentinelConnectionParams.getMasterName()).matches()) {
            throw new InitialisationException((Throwable)new InvalidMasterNameException(), null);
        }
        if (this.sentinelConnectionParams.getIndex() < 0) {
            throw new InitialisationException((Throwable)new InvalidDatabaseIndexException(), null);
        }
    }

    @Override
    public ExecutableRedisConnection connect(Scheduler scheduler, ObjectSerializer serializer, JedisPoolConfig jedisPoolConfig) {
        logger.info("Redis connector ready, sentinel hosts: {}, , timeout: {}", (Object)this.sentinelConnectionParams.getSentinelsHosts(), (Object)this.sentinelConnectionParams.getConnectionTimeout());
        Set sentinels = Stream.of(this.sentinelConnectionParams.getSentinelsHosts().split(",")).collect(Collectors.toSet());
        return new RedisPoolConnection((JedisPoolAbstract)new JedisSentinelPool(this.sentinelConnectionParams.getMasterName(), sentinels, (GenericObjectPoolConfig)jedisPoolConfig, (int)this.sentinelConnectionParams.getConnectionTimeUnit().toMillis(this.sentinelConnectionParams.getConnectionTimeout()), (int)this.sentinelConnectionParams.getConnectionTimeUnit().toMillis(this.sentinelConnectionParams.getConnectionTimeout()), null, this.sentinelConnectionParams.getPassword(), this.sentinelConnectionParams.getIndex(), this.getConfigName(), (int)this.sentinelConnectionParams.getSentinelConnectionTimeUnit().toMillis(this.sentinelConnectionParams.getSentinelConnectionTimeout()), (int)this.sentinelConnectionParams.getSentinelConnectionTimeUnit().toMillis(this.sentinelConnectionParams.getSentinelConnectionTimeout()), null, this.sentinelConnectionParams.getSentinelPassword(), this.getConfigName()), this.sentinelConnectionParams.getEntryTTL(), serializer, scheduler);
    }
}

