/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.mule.extension.redis.api.connection.provider.EndpointIdentificationAlgorithm;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.connection.provider.RedisConnectionProvider;
import org.mule.extension.redis.internal.error.exceptions.InvalidTLSConfigurationException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import redis.clients.jedis.JedisPoolConfig;

public abstract class RedisSSLConnectionProvider<C extends ExecutableRedisConnection>
extends RedisConnectionProvider<C> {
    @Parameter
    @Placement(tab="Security", order=1)
    @DisplayName(value="TLS Configuration")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TlsContextFactory tlsContext;
    @Parameter
    @Placement(tab="Security", order=2)
    @DisplayName(value="Endpoint identification algorithm")
    @Optional(defaultValue="DISABLED")
    @Summary(value="The endpoint identification algorithm used by clients to validate server host name.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private EndpointIdentificationAlgorithm endpointIdentificationAlgorithm;
    private SSLSocketFactory sslSocketFactory;
    private SSLParameters sslParameters;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.tlsContext);
    }

    @Override
    protected C connect(Scheduler scheduler, ObjectSerializer serializer, JedisPoolConfig jedisPoolConfig) {
        boolean isSSL;
        boolean bl = isSSL = this.tlsContext != null;
        if (isSSL) {
            try {
                SSLContext sslContext = this.tlsContext.createSslContext();
                this.sslParameters = sslContext.getDefaultSSLParameters();
                this.sslParameters.setEndpointIdentificationAlgorithm(this.endpointIdentificationAlgorithm.name().toLowerCase().replace("disabled", ""));
                this.sslParameters.setCipherSuites(this.tlsContext.getEnabledCipherSuites());
                this.sslParameters.setProtocols(this.tlsContext.getEnabledProtocols());
                this.sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new InvalidTLSConfigurationException(e);
            }
        }
        return this.connect(scheduler, serializer, jedisPoolConfig, isSSL, this.sslParameters, this.sslSocketFactory);
    }

    protected abstract C connect(Scheduler var1, ObjectSerializer var2, JedisPoolConfig var3, boolean var4, SSLParameters var5, SSLSocketFactory var6);
}

