/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection.provider;

import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.connection.RedisPoolConnection;
import org.mule.extension.redis.internal.connection.param.NonClusteredConnectionParams;
import org.mule.extension.redis.internal.connection.provider.RedisSSLConnectionProvider;
import org.mule.extension.redis.internal.stereotype.ObjectStoreConnectionStereotype;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.stereotype.Stereotype;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolAbstract;
import redis.clients.jedis.JedisPoolConfig;

@Alias(value="nonclustered")
@DisplayName(value="NonClustered")
@Stereotype(value=ObjectStoreConnectionStereotype.class)
public class PooledConnectionProvider
extends RedisSSLConnectionProvider<ExecutableRedisConnection>
implements CachedConnectionProvider<ExecutableRedisConnection> {
    private static final Logger logger = LoggerFactory.getLogger(PooledConnectionProvider.class);
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private NonClusteredConnectionParams pooledConnectionParams;

    @Override
    public ExecutableRedisConnection connect(Scheduler scheduler, ObjectSerializer serializer, JedisPoolConfig jedisPoolConfig, boolean isSSL, SSLParameters sslParameters, SSLSocketFactory socketFactory) {
        logger.info("Redis connector ready, host: {}, port: {}, timeout: {}", new Object[]{this.pooledConnectionParams.getHost(), this.pooledConnectionParams.getPort(), this.pooledConnectionParams.getConnectionTimeout()});
        return new RedisPoolConnection((JedisPoolAbstract)new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, this.pooledConnectionParams.getHost(), this.pooledConnectionParams.getPort(), (int)this.pooledConnectionParams.getConnectionTimeUnit().toMillis(this.pooledConnectionParams.getConnectionTimeout()), this.pooledConnectionParams.getPassword(), isSSL, socketFactory, sslParameters, null), this.pooledConnectionParams.getEntryTTL(), serializer, scheduler);
    }
}

