/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.redis.internal.connection;

import java.util.function.Function;
import org.mule.extension.redis.internal.connection.ExecutableRedisConnection;
import org.mule.extension.redis.internal.service.PooledApiService;
import org.mule.extension.redis.internal.service.noncluster.JedisClientAdapter;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.serialization.ObjectSerializer;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolAbstract;

public class RedisPoolConnection
extends ExecutableRedisConnection<Jedis> {
    private final JedisPoolAbstract jedisPool;

    public RedisPoolConnection(JedisPoolAbstract jedisPool, Integer entryTTL, ObjectSerializer serializer, Scheduler scheduler) {
        super(entryTTL, serializer, scheduler, PooledApiService::new);
        this.jedisPool = jedisPool;
    }

    @Override
    public <T> T doExecute(Function<Jedis, T> function) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            T t = function.apply(jedis);
            return t;
        }
    }

    public void validate() {
        ((Jedis)this.jedisPool.getResource()).echo("ping");
    }

    @Override
    public void disconnect() {
        super.disconnect();
        this.jedisPool.close();
    }

    public JedisClientAdapter getClientAdapter() {
        return new JedisClientAdapter((Jedis)this.jedisPool.getResource());
    }
}

