/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.internal.util.CustomDateTimeConverter;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.json.Converter;
import org.bson.json.JsonWriterSettings;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConverterUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConverterUtils.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final String REGEX_ISO_DATE = "(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d\\.\\d+([+-][0-2]\\d:[0-5]\\d|Z))|(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d:[0-5]\\d([+-][0-2]\\d:[0-5]\\d|Z))|(\\d{4}-[01]\\d-[0-3]\\dT[0-2]\\d:[0-5]\\d([+-][0-2]\\d:[0-5]\\d|Z))";

    private ConverterUtils() {
    }

    public static Document fromSortByJsonToDocument(InputStream sortBy, String encoding) {
        String sortCriteria = "";
        if (sortBy != null) {
            sortCriteria = org.mule.runtime.core.api.util.IOUtils.toString((InputStream)sortBy, (String)encoding);
            if (sortCriteria.isEmpty()) {
                return null;
            }
        } else {
            return null;
        }
        Document document = new Document();
        try {
            Object object = gson.fromJson(sortCriteria, Object.class);
            if (object instanceof Map) {
                ((Map)object).forEach((key, value) -> document.append(key, (Object)IndexOrder.valueOf((String)value).getValue()));
                return document;
            }
            if (((ArrayList)object).size() == 0) {
                return null;
            }
            List listMaps = (List)object;
            listMaps.stream().filter(eachMap -> {
                Set keySet = eachMap.keySet();
                String stringValue = (String)eachMap.get(eachMap.keySet().iterator().next());
                return keySet.size() == 1 && (StringUtils.isNotBlank((CharSequence)stringValue) && stringValue.equals(IndexOrder.ASC.name()) || stringValue.equals(IndexOrder.DESC.name()));
            }).forEach(eachMap -> {
                Set keySet = eachMap.keySet();
                document.append((String)keySet.iterator().next(), (Object)IndexOrder.valueOf((String)eachMap.get(keySet.iterator().next())).getValue());
            });
        }
        catch (Exception e) {
            logger.error("Error trying to transform InputStream to Document", (Throwable)e);
        }
        return document;
    }

    public static InputStream toJsonResult(Document document, String encoding) {
        if (document != null) {
            try {
                return IOUtils.toInputStream((String)document.toJson(JsonWriterSettings.builder().dateTimeConverter((Converter)new CustomDateTimeConverter()).build()), (String)encoding);
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    public static Document toDocument(InputStream jsonInputStream, String encoding) {
        if (jsonInputStream != null) {
            return ConverterUtils.convertStringToDateFields(Document.parse((String)org.mule.runtime.core.api.util.IOUtils.toString((InputStream)jsonInputStream, (String)encoding)));
        }
        return null;
    }

    public static Document toNonNullDocument(InputStream jsonInputStream, String encoding) {
        return Optional.ofNullable(ConverterUtils.toDocument(jsonInputStream, encoding)).orElseGet(Document::new);
    }

    public static Document fromFunction(String function, Document document) {
        return new Document(function, (Object)document);
    }

    public static Document convertStringToDateFields(Document document) {
        for (Map.Entry entryDoc : document.entrySet()) {
            if (entryDoc.getValue() instanceof Document) {
                entryDoc.setValue(ConverterUtils.convertStringToDateFields((Document)entryDoc.getValue()));
                continue;
            }
            if (entryDoc.getValue() instanceof List) {
                for (Object item : (List)entryDoc.getValue()) {
                    if (!(item instanceof Document)) continue;
                    ConverterUtils.convertStringToDateFields((Document)item);
                }
                continue;
            }
            if (entryDoc.getValue() == null || !entryDoc.getValue().toString().matches(REGEX_ISO_DATE)) continue;
            entryDoc.setValue(Date.from(Instant.from(OffsetDateTime.parse(entryDoc.getValue().toString(), DateTimeFormatter.ISO_DATE_TIME))));
        }
        return document;
    }
}

