/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.source;

import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.metadata.DocMetadataResolver;
import com.mulesoft.connector.mongo.internal.service.SourceService;
import com.mulesoft.connector.mongo.internal.valueprovider.CollectionsValueProvider;
import com.mulesoft.connector.mongo.internal.valueprovider.FieldValueProvider;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@Alias(value="object-listener", description="Listener for object events.")
@DisplayName(value="On Object Listener")
@MetadataScope(keysResolver=DocMetadataResolver.class, outputResolver=DocMetadataResolver.class)
@MediaType(value="application/json")
public class OnObjectListenerSource
extends PollingSource<InputStream, Void> {
    @Parameter
    @OfValues(value=CollectionsValueProvider.class)
    @MetadataKeyId
    private String collectionName;
    @Parameter
    @OfValues(value=FieldValueProvider.class)
    private String watermarkField;
    @Config
    private MongoConfig config;
    @Connection
    private ConnectionProvider<MongoConnection> connectionProvider;
    private MongoConnection connection;
    private SourceService sourceService;

    protected void doStart() throws MuleException {
        if (StringUtils.isBlank((String)this.watermarkField)) {
            throw new ModuleException("Watermark field can't be null", (ErrorTypeDefinition)MongoErrorType.INVALID_INPUT);
        }
        this.connection = (MongoConnection)this.connectionProvider.connect();
        this.sourceService = new SourceService(this.config, this.connection);
        this.sourceService.extractFieldClassAndLastWatermark(this.collectionName, this.watermarkField);
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<InputStream, Void> pollContext) {
        this.sourceService.poll(pollContext, this.watermarkField, this.collectionName);
    }

    public void onRejectedItem(Result<InputStream, Void> result, SourceCallbackContext sourceCallbackContext) {
    }
}

