/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service.callable;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class OplogCollection {
    private static final String MAIN_OPLOG = "$main";
    private static final String REPLICA_OPLOG = "rs";
    private static final String IS_MASTER_FIELD = "ismaster";
    private MongoDatabase admin;
    private MongoDatabase local;

    public OplogCollection(MongoDatabase admin, MongoDatabase local) {
        this.admin = admin;
        this.local = local;
    }

    public MongoCollection<Document> getOplogCollection() {
        String oplogCollectionName = "oplog.";
        oplogCollectionName = oplogCollectionName + (this.isMain() ? MAIN_OPLOG : REPLICA_OPLOG);
        return this.local.getCollection(oplogCollectionName);
    }

    private boolean isMain() {
        Document commandResult = this.admin.runCommand((Bson)new Document(IS_MASTER_FIELD, (Object)1));
        boolean isMain = commandResult.getBoolean((Object)IS_MASTER_FIELD, false);
        if (commandResult.containsKey((Object)"hosts")) {
            return false;
        }
        if (!isMain) {
            throw new ModuleException("oplog mode is only supported on master or replica set member", (ErrorTypeDefinition)MongoErrorType.INVALID_INPUT);
        }
        return true;
    }
}

