/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service.callable;

import com.mongodb.DefaultDBDecoder;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOptions;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.service.CollectionService;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public abstract class MongoRestorer {
    private static final UpdateOptions UPDATE_OPTIONS = new UpdateOptions().upsert(true);
    private static final String SYSTEM_COLLECTION_PREFIX = "system.";
    private final boolean dropCollections;
    private final CollectionService collectionService;

    public MongoRestorer(boolean dropCollections, CollectionService collectionService) {
        this.dropCollections = dropCollections;
        this.collectionService = collectionService;
    }

    protected void dropCollectionIfNeeded(MongoDatabase database, String collectionName) {
        if (this.dropCollections && !this.isSystemCollection(collectionName) && this.collectionService.existsCollection(database, collectionName)) {
            this.collectionService.dropCollection(database, collectionName);
        } else if (collectionName.contains("-")) {
            String[] collectionSplitted = collectionName.split("-");
            collectionName = collectionSplitted[1];
            if (this.dropCollections && !this.isSystemCollection(collectionName) && this.collectionService.existsCollection(database, collectionName)) {
                this.collectionService.dropCollection(database, collectionName);
            }
        }
    }

    private boolean isSystemCollection(String collection) {
        return collection.startsWith(SYSTEM_COLLECTION_PREFIX);
    }

    public static boolean isUserCollection(String collection) {
        return collection.endsWith("system.user");
    }

    protected void restoreCollection(MongoDatabase database, String collectionName, InputStream fileIO) {
        MongoCollection<Document> collection = this.collectionService.getCollection(database, collectionName);
        List<Document> dbObjects = this.getDocumentsFromFile(fileIO);
        if (MongoRestorer.isUserCollection(collectionName)) {
            for (Document currentDocument : collection.find()) {
                if (dbObjects.contains(currentDocument)) continue;
                collection.findOneAndDelete((Bson)currentDocument);
            }
        }
        for (Document document : dbObjects) {
            Object id = document.get((Object)"_id");
            if (id == null) {
                collection.insertOne((Object)document);
                continue;
            }
            collection.updateOne(Filters.eq((String)"_id", (Object)id), (Bson)ConverterUtils.fromFunction("$set", document), UPDATE_OPTIONS);
        }
    }

    public List<Document> getDocumentsFromFile(InputStream input) {
        DefaultDBDecoder bsonDecoder = new DefaultDBDecoder();
        ArrayList<Document> documents = new ArrayList<Document>();
        try {
            BufferedInputStream stream = new BufferedInputStream(input);
            do {
                BSONObject bsonObject;
                if ((bsonObject = bsonDecoder.readObject((InputStream)stream)) == null) continue;
                Document doc = new Document(bsonObject.toMap());
                documents.add(doc);
            } while (stream.available() != 0);
            return documents;
        }
        catch (IOException e) {
            throw new ModuleException((ErrorTypeDefinition)MongoErrorType.INVALID_INPUT, (Throwable)e);
        }
    }
}

