/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service.callable;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mulesoft.connector.mongo.internal.service.callable.DumpWriter;
import java.util.concurrent.Callable;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoDumpCollection
implements Callable<Void> {
    private final MongoCollection<Document> collection;
    private DumpWriter dumpWriter;
    private String name;
    private Document query;

    public MongoDumpCollection(MongoCollection<Document> collection, DumpWriter dumpWriter) {
        this.collection = collection;
        this.dumpWriter = dumpWriter;
    }

    @Override
    public Void call() {
        FindIterable cursor = this.query != null ? this.collection.find((Bson)this.query) : this.collection.find();
        cursor.sort((Bson)new Document("$natural", (Object)-1));
        for (Document document : cursor) {
            this.dumpWriter.writeObject(this.name != null ? this.name : this.collection.getNamespace().getCollectionName(), document);
        }
        return null;
    }

    public void setDumpWriter(DumpWriter dumpWriter) {
        this.dumpWriter = dumpWriter;
    }

    public void setQuery(Document query) {
        this.query = query;
    }

    public void setName(String name) {
        this.name = name;
    }
}

