/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service.callable;

import com.google.common.base.MoreObjects;
import com.mongodb.client.MongoDatabase;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.service.CollectionService;
import com.mulesoft.connector.mongo.internal.service.DocumentService;
import com.mulesoft.connector.mongo.internal.service.callable.MongoRestorer;
import com.mulesoft.connector.mongo.internal.service.callable.RestoreFileDirectory;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.Document;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class MongoDirectoryRestorer
extends MongoRestorer {
    private static final String BSON_EXTENSION = "bson";
    private final boolean oplogReplay;
    private final String inputPath;
    private DocumentService documentService;
    private String databaseName;

    public MongoDirectoryRestorer(String databaseName, boolean drop, boolean oplogReplay, String inputPath, CollectionService collectionService, DocumentService documentService) {
        super(drop, collectionService);
        this.oplogReplay = oplogReplay;
        this.inputPath = inputPath;
        this.documentService = documentService;
        this.databaseName = databaseName;
    }

    public void restore(MongoDatabase database, String encoding) {
        ArrayList<RestoreFileDirectory> oplogRestores = new ArrayList<RestoreFileDirectory>();
        List<RestoreFileDirectory> listRestoredFiles = this.getRestoreFilesFromDirectory(this.inputPath);
        for (RestoreFileDirectory restoreFileDirectory : listRestoredFiles) {
            String collectionName = restoreFileDirectory.getCollection();
            if (!this.isOplog(collectionName)) {
                try {
                    FileInputStream fis = new FileInputStream(restoreFileDirectory.getFile());
                    this.dropCollectionIfNeeded(database, collectionName);
                    this.restoreCollection(database, collectionName, fis);
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new ModuleException((ErrorTypeDefinition)MongoErrorType.INVALID_INPUT, (Throwable)e);
                }
            }
            oplogRestores.add(restoreFileDirectory);
        }
        if (this.oplogReplay && !oplogRestores.isEmpty()) {
            for (RestoreFileDirectory oplogRestore : oplogRestores) {
                this.documentService.executeCommand(database, ConverterUtils.toJsonResult(new Document("applyOps", (Object)this.filterOplogForDatabase(oplogRestore).toArray()), encoding), encoding);
            }
        }
    }

    private List<Document> filterOplogForDatabase(RestoreFileDirectory oplogFile) {
        ArrayList<Document> dbOplogEntries = new ArrayList<Document>();
        try {
            for (Document oplogEntry : this.getDocumentsFromFile(new FileInputStream(oplogFile.getFile()))) {
                if (!((String)oplogEntry.get((Object)"ns")).startsWith(this.databaseName + ".")) continue;
                dbOplogEntries.add(oplogEntry);
            }
        }
        catch (FileNotFoundException e) {
            throw new ModuleException((ErrorTypeDefinition)MongoErrorType.INVALID_INPUT, (Throwable)e);
        }
        return dbOplogEntries;
    }

    private void processRestoreFiles(File input, List<RestoreFileDirectory> restoreFileDirectories) {
        File unzippedFolder = this.isZipFile(input) ? new File(this.removeExtension(input.getPath())) : input;
        if (unzippedFolder.isDirectory()) {
            for (File file : (File[])MoreObjects.firstNonNull((Object)unzippedFolder.listFiles(), (Object)new File[0])) {
                this.processRestoreFiles(file, restoreFileDirectories);
            }
        } else if (this.isBsonFile(unzippedFolder)) {
            restoreFileDirectories.add(new RestoreFileDirectory(unzippedFolder));
        }
    }

    private void processRestoreFromDirectory(File input, List<RestoreFileDirectory> restoreFileDirectories) {
        if (input.isDirectory()) {
            for (File file : (File[])MoreObjects.firstNonNull((Object)input.listFiles(), (Object)new File[0])) {
                this.processRestoreFiles(file, restoreFileDirectories);
            }
        }
    }

    private List<RestoreFileDirectory> getRestoreFilesFromDirectory(String inputPath) {
        ArrayList<RestoreFileDirectory> restoreFileDirectories = new ArrayList<RestoreFileDirectory>();
        this.processRestoreFromDirectory(new File(inputPath), restoreFileDirectories);
        Collections.sort(restoreFileDirectories);
        return restoreFileDirectories;
    }

    private boolean isOplog(String collection) {
        return collection.startsWith("oplog");
    }

    private boolean isZipFile(File file) {
        return this.hasExtension(file, "zip");
    }

    private boolean isBsonFile(File file) {
        return this.hasExtension(file, BSON_EXTENSION);
    }

    private boolean hasExtension(File file, String extension) {
        return file.getName().endsWith("." + extension);
    }

    private String removeExtension(String path) {
        return path.substring(0, path.lastIndexOf(46));
    }
}

