/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service.callable;

import com.mongodb.BasicDBObject;
import com.mulesoft.connector.mongo.internal.bson.MuleBasicBSONEncoder;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.service.callable.DumpWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import org.bson.BSONObject;
import org.bson.Document;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonDumpWriter
extends DumpWriter {
    private static final String BSON_EXTENSION = "bson";
    private static final Logger logger = LoggerFactory.getLogger(BsonDumpWriter.class);

    public BsonDumpWriter(String outputDirectory, String databaseName, String outputNamePrefix) {
        super(outputDirectory, databaseName, outputNamePrefix);
    }

    @Override
    public String getExtension() {
        return BSON_EXTENSION;
    }

    @Override
    public void writeObject(String collection, Document document) {
        File outputFile = new File(this.getFilePath(collection));
        File folder = outputFile.getParentFile();
        if (!folder.exists() && !folder.mkdirs()) {
            logger.warn("Couldn't create dir: {}", (Object)folder);
        }
        MuleBasicBSONEncoder encoder = new MuleBasicBSONEncoder();
        try (FileOutputStream outputStream = new FileOutputStream(outputFile, true);){
            outputStream.write(encoder.encode((BSONObject)new BasicDBObject((Map)document)));
        }
        catch (IOException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)MongoErrorType.INVALID_INPUT);
        }
    }
}

