/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.google.common.collect.ImmutableList;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import com.mulesoft.connector.mongo.internal.util.SourceWatermarkComparator;
import com.mulesoft.connector.mongo.internal.util.WaterMark;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;

public class SourceService {
    private static final int POLL_SIZE = 100;
    private static final int ASC = 1;
    private static final int DESC = -1;
    private MongoConnection connection;
    private MongoConfig config;
    private SourceWatermarkComparator comparator;
    private Object collectionLastValue;
    private WaterMark pollLastWatermark;

    public SourceService(MongoConfig config, MongoConnection connection) {
        this.connection = connection;
        this.config = config;
        this.comparator = new SourceWatermarkComparator();
        this.pollLastWatermark = new WaterMark();
    }

    public void extractFieldClassAndLastWatermark(String collectionName, String watermarkField) {
        Iterator<Document> documents = this.getDocuments(new Document(), 1, collectionName, watermarkField, -1);
        if (documents.hasNext()) {
            Document document = documents.next();
            this.collectionLastValue = document.get((Object)watermarkField);
        }
    }

    public void poll(PollContext<InputStream, Void> pollContext, String watermarkField, String collectionName) {
        pollContext.setWatermarkComparator((Comparator)this.comparator);
        this.getDocuments(this.createQuery(pollContext, watermarkField), 100, collectionName, watermarkField, 1).forEachRemaining(entity -> pollContext.accept(item -> item.setResult(this.toResult((Document)entity)).setWatermark((Serializable)new WaterMark(watermarkField, entity.get((Object)watermarkField))).setId(this.getResultId((Document)entity, watermarkField))));
    }

    private Iterator<Document> getDocuments(Document query, int size, String collectionName, String watermarkField, int order) {
        return this.connection.findObjects(this.config, collectionName, ConverterUtils.toJsonResult(query, this.config.getEncoding()), (List<String>)ImmutableList.of(), 0, size, ConverterUtils.toJsonResult(new Document(watermarkField, (Object)order), this.config.getEncoding())).iterator();
    }

    private Document createQuery(PollContext<InputStream, Void> pollContext, String watermarkField) {
        if (pollContext.getWatermark().isPresent()) {
            this.pollLastWatermark = (WaterMark)pollContext.getWatermark().get();
        }
        if (Optional.ofNullable(this.pollLastWatermark.getField()).orElse("").equals(watermarkField)) {
            if (this.pollLastWatermark.getValue() != null) {
                return new Document(watermarkField, (Object)new Document("$gt", this.pollLastWatermark.getValue()));
            }
            return new Document(watermarkField, (Object)new Document("$ne", null));
        }
        if (this.collectionLastValue != null) {
            return new Document(watermarkField, (Object)new Document("$gt", this.collectionLastValue));
        }
        return new Document(watermarkField, (Object)new Document("$ne", null));
    }

    private String getResultId(Document entity, String watermarkField) {
        return entity.getObjectId((Object)"_id").toString() + "-" + Optional.ofNullable(entity.get((Object)watermarkField)).orElse("").toString();
    }

    private Result<InputStream, Void> toResult(Document entity) {
        return Result.builder().output((Object)ConverterUtils.toJsonResult(entity, this.config.getEncoding())).build();
    }
}

