/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;

public class FindObjectsRequest {
    private final String collection;
    private final Document query;
    private final List<String> fields;
    private final Integer pageSize;
    private final Integer limit;
    private final Document sortBy;
    private final boolean returnId;

    public FindObjectsRequest(String collection, InputStream query, String fields, Integer pageSize, Integer limit, InputStream sortBy, boolean returnId, String encoding) {
        this(collection, query, Arrays.stream(fields.split("\\s*,\\s*")).filter(StringUtils::isNotBlank).collect(Collectors.toList()), pageSize, limit, sortBy, returnId, encoding);
    }

    public FindObjectsRequest(String collection, InputStream query, List<String> fields, Integer pageSize, Integer limit, InputStream sortBy, boolean returnId, String encoding) {
        this.collection = collection;
        this.query = ConverterUtils.toNonNullDocument(query, encoding);
        this.fields = fields;
        this.pageSize = pageSize;
        this.limit = limit;
        this.sortBy = ConverterUtils.toDocument(sortBy, encoding);
        this.returnId = returnId;
    }

    public FindObjectsRequest(String collection, Document query, String fields, Integer pageSize, Integer limit, Document sortBy, boolean returnId) {
        this(collection, query, Arrays.stream(fields.split("\\s*,\\s*")).filter(StringUtils::isNotBlank).collect(Collectors.toList()), pageSize, limit, sortBy, returnId);
    }

    public FindObjectsRequest(String collection, Document query, List<String> fields, Integer pageSize, Integer limit, Document sortBy, boolean returnId) {
        this.collection = collection;
        this.query = query;
        this.fields = fields;
        this.pageSize = pageSize;
        this.limit = limit;
        this.sortBy = sortBy;
        this.returnId = returnId;
    }

    public String getCollection() {
        return this.collection;
    }

    public Document getQuery() {
        return this.query;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Document getSortBy() {
        return this.sortBy;
    }

    public boolean isReturnId() {
        return this.returnId;
    }
}

