/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.mongodb.MongoGridFSException;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.GridFSDownloadStream;
import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.model.MuleBsonObjectIdAsObject;
import com.mulesoft.connector.mongo.internal.model.MuleBsonObjectIdAsString;
import com.mulesoft.connector.mongo.internal.model.MuleGridFSFile;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileService {
    private static final DataType JSON_STRING = DataType.builder().type(String.class).mediaType(MediaType.APPLICATION_JSON).build();
    private static final Logger logger = LoggerFactory.getLogger(FileService.class);
    private static final String UPLOAD_DATE = "uploadDate";

    private GridFSBucket getGridFs(MongoDatabase database) {
        return GridFSBuckets.create((MongoDatabase)database);
    }

    public InputStream createFile(MongoDatabase database, MongoConfig config, InputStream content, String filename, InputStream metadata) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().metadata(ConverterUtils.toDocument(metadata, config.getEncoding()));
        ObjectId fileId = this.getGridFs(database).uploadFromStream(filename, content, uploadOptions);
        return this.muleGridFileToJson(config, this.findFile(database, ConverterUtils.toJsonResult(new Document("_id", (Object)fileId), config.getEncoding()), config.getEncoding()));
    }

    public List<TypedValue<InputStream>> findFiles(MongoDatabase database, MongoConfig config, InputStream query, InputStream sort, StreamingHelper streamingHelper) {
        Iterable<MuleGridFSFile> iterable;
        if (sort != null) {
            Document sortBy = ConverterUtils.toDocument(sort, config.getEncoding());
            sortBy.replace((Object)"file_id", (Object)IndexOrder.valueOf((String)Optional.ofNullable(sortBy.get((Object)"file_id")).orElse("ASC")).getValue());
            sortBy.replace((Object)UPLOAD_DATE, (Object)IndexOrder.valueOf((String)Optional.ofNullable(sortBy.get((Object)UPLOAD_DATE)).orElse("ASC")).getValue());
            iterable = this.adaptList(this.getGridFs(database).find((Bson)Optional.ofNullable(ConverterUtils.toDocument(query, config.getEncoding())).orElse(new Document())).sort((Bson)sortBy));
        } else {
            iterable = this.adaptList(this.getGridFs(database).find((Bson)Optional.ofNullable(ConverterUtils.toDocument(query, config.getEncoding())).orElse(new Document())));
        }
        ArrayList<TypedValue<InputStream>> listOfFiles = new ArrayList<TypedValue<InputStream>>();
        iterable.forEach(file -> listOfFiles.add(new TypedValue(streamingHelper.resolveCursorProvider((Object)this.muleGridFileToJson(config, (MuleGridFSFile)file)), JSON_STRING)));
        return listOfFiles;
    }

    private MuleGridFSFile findFile(MongoDatabase database, InputStream query, String encoding) {
        Document document = ConverterUtils.toDocument(query, encoding);
        GridFSFile gridFs = (GridFSFile)this.getGridFs(database).find((Bson)document).first();
        if (gridFs == null) {
            throw new ModuleException(String.format("No file found for query %s", document), (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
        }
        return this.adapt(gridFs);
    }

    public Result<TypedValue<Object>, TypedValue<InputStream>> getFileContent(MongoDatabase database, MongoConfig config, InputStream fileId, StreamingHelper streamingHelper) {
        GridFSDownloadStream fileContent = null;
        try {
            fileContent = this.getGridFs(database).openDownloadStream(this.readObjectId(config, fileId));
            return Result.builder().output((Object)TypedValue.of((Object)streamingHelper.resolveCursorProvider((Object)fileContent))).attributes((Object)new TypedValue(streamingHelper.resolveCursorProvider((Object)this.muleGridFileToJson(config, this.adapt(fileContent.getGridFSFile()))), JSON_STRING)).attributesMediaType(MediaType.JSON).build();
        }
        catch (MongoGridFSException e) {
            if (fileContent != null) {
                fileContent.close();
            }
            throw new ModuleException((ErrorTypeDefinition)MongoErrorType.NOT_FOUND, (Throwable)e);
        }
    }

    public void removeFiles(MongoDatabase database, MongoConfig config, InputStream fileId) {
        if (fileId == null) {
            this.getGridFs(database).drop();
        } else {
            try {
                ObjectId objectId = this.readObjectId(config, fileId);
                this.getGridFs(database).delete(objectId);
            }
            catch (MongoGridFSException e) {
                throw new ModuleException((ErrorTypeDefinition)MongoErrorType.NOT_FOUND, (Throwable)e);
            }
        }
    }

    private ObjectId readObjectId(MongoConfig config, InputStream fileId) {
        try {
            byte[] byteContent = this.getPayloadAsByteArray(fileId);
            String jsonString = new String(byteContent);
            if (jsonString.contains("timestamp")) {
                MuleBsonObjectIdAsObject objectIdWithTimestamp = (MuleBsonObjectIdAsObject)config.getGsonInstance().fromJson(jsonString, MuleBsonObjectIdAsObject.class);
                return objectIdWithTimestamp.getValue();
            }
            MuleBsonObjectIdAsString muleBsonObjectIdAsString = (MuleBsonObjectIdAsString)config.getGsonInstance().fromJson(jsonString, MuleBsonObjectIdAsString.class);
            return new ObjectId(muleBsonObjectIdAsString.getValue());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private MuleGridFSFile adapt(GridFSFile gridFSFile) {
        return new MuleGridFSFile(this.toJavaType(gridFSFile.getId()), gridFSFile.getFilename(), gridFSFile.getLength(), gridFSFile.getChunkSize(), gridFSFile.getUploadDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), (Map<String, Object>)gridFSFile.getMetadata());
    }

    private Iterable<MuleGridFSFile> adaptList(GridFSFindIterable gridFSFiles) {
        return StreamSupport.stream(gridFSFiles.spliterator(), false).map(gridFSFile -> this.adapt((GridFSFile)gridFSFile)).collect(Collectors.toList());
    }

    private byte[] getPayloadAsByteArray(InputStream payload) throws IOException {
        byte[] answer = new byte[]{};
        if (payload != null) {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = payload.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            answer = buffer.toByteArray();
        }
        if (answer.length == 0) {
            logger.warn(" Payload contents are null or empty ");
        }
        return answer;
    }

    private InputStream muleGridFileToJson(MongoConfig config, MuleGridFSFile file) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", file.getId());
        map.put("filename", file.getFilename());
        map.put("length", file.getLength());
        map.put("chunkSize", file.getChunkSize());
        map.put(UPLOAD_DATE, file.getUploadDate());
        map.put("metadata", file.getMetadata());
        return IOUtils.toInputStream((String)config.getGsonInstance().toJson(map));
    }

    private BsonValue toJavaType(Object bsonValue) {
        BsonValue value = (BsonValue)bsonValue;
        switch (value.getBsonType()) {
            case INT32: {
                return value.asInt32();
            }
            case INT64: {
                return value.asInt64();
            }
            case STRING: {
                return value.asString();
            }
            case DECIMAL128: {
                return value.asDecimal128();
            }
            case DOUBLE: {
                return value.asDouble();
            }
            case BOOLEAN: {
                return value.asBoolean();
            }
            case OBJECT_ID: {
                return value.asObjectId();
            }
            case BINARY: {
                return value.asBinary();
            }
            case DATE_TIME: {
                return value.asDateTime();
            }
        }
        return value;
    }
}

