/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mongodb.CursorType;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteError;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mulesoft.connector.mongo.api.UpdateDocumentResult;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.service.CollectionService;
import com.mulesoft.connector.mongo.internal.service.FindObjectsRequest;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.DocumentCodec;
import org.bson.conversions.Bson;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentService {
    private static final Logger logger = LoggerFactory.getLogger(DocumentService.class);
    private final DataType JSON_STREAM = DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_JSON).build();
    private CollectionService collectionService;

    public DocumentService(CollectionService collectionService) {
        this.collectionService = collectionService;
    }

    public long countObjects(MongoDatabase database, String encoding, String collection, InputStream query) {
        if (query == null) {
            return database.getCollection(collection).countDocuments();
        }
        return database.getCollection(collection).countDocuments((Bson)ConverterUtils.toDocument(query, encoding));
    }

    public FindIterable<Document> findObjects(MongoDatabase database, MongoConfig config, String collection, InputStream query, List<String> fields, Integer numToSkip, Integer limit, InputStream sortBy) {
        return this.findObjectsByRequest(database, new FindObjectsRequest(collection, query, fields, numToSkip, limit, sortBy, true, config.getEncoding()));
    }

    public FindIterable<Document> findObjectsByRequest(MongoDatabase database, FindObjectsRequest request) {
        FindIterable dbCursor = database.getCollection(request.getCollection()).find((Bson)request.getQuery()).projection(this.from(request.getFields(), request.isReturnId())).cursorType(CursorType.NonTailable);
        if (request.getLimit() != null) {
            dbCursor = dbCursor.limit(request.getLimit().intValue());
        }
        if (request.getSortBy() != null) {
            dbCursor.sort((Bson)request.getSortBy());
        }
        return dbCursor;
    }

    public InputStream insertObject(MongoDatabase database, String collection, InputStream document, String encoding) {
        Document insertDocument = ConverterUtils.toDocument(document, encoding);
        try {
            Method insertDocumentMethod = Class.forName(MongoCollection.class.getName()).getMethod("insertOne", Object.class);
            insertDocumentMethod.invoke((Object)database.getCollection(collection), insertDocument);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            logger.trace(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new MuleRuntimeException(throwable);
        }
        return ConverterUtils.toJsonResult(insertDocument, encoding);
    }

    public BulkOperationResult<TypedValue<InputStream>> insertDocuments(MongoDatabase database, MongoConfig config, String collectionName, InputStream documents, boolean writeOrdered, StreamingHelper streamingHelper) {
        List<Document> listDocuments = this.convertInputStreamToDocumentList(documents);
        return this.insertObjects(database, collectionName, listDocuments, writeOrdered, streamingHelper, config.getEncoding());
    }

    private BulkOperationResult<TypedValue<InputStream>> insertObjects(MongoDatabase database, String collection, List<Document> documents, boolean ordered, StreamingHelper streamingHelper, String encoding) {
        try {
            if (!this.collectionService.existsCollection(database, collection)) {
                throw new ModuleException(String.format("The collection '%s' does not exist", collection), (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
            }
            if (documents.size() == 1) {
                database.getCollection(collection).insertOne((Object)documents.get(0));
                return this.createResultDocument(documents, streamingHelper, ordered, encoding);
            }
            ArrayList<InsertOneModel> inserts = new ArrayList<InsertOneModel>(documents.size());
            for (Document document : documents) {
                inserts.add(new InsertOneModel((Object)new DocumentCodec().generateIdIfAbsentFromDocument(document)));
            }
            database.getCollection(collection).bulkWrite(inserts, new BulkWriteOptions().ordered(ordered));
            return this.createResultDocument(documents, streamingHelper, ordered, encoding);
        }
        catch (MongoBulkWriteException | MongoWriteException e) {
            logger.debug(e.getMessage(), e);
            return this.createResultDocument(documents, (MongoServerException)e, streamingHelper, ordered, encoding);
        }
    }

    private BulkOperationResult<TypedValue<InputStream>> createResultDocument(List<Document> documents, StreamingHelper streamingHelper, boolean ordered, String encoding) {
        return this.createResultDocument(documents, null, streamingHelper, ordered, encoding);
    }

    private BulkOperationResult<TypedValue<InputStream>> createResultDocument(List<Document> documents, MongoServerException e, StreamingHelper streamingHelper, boolean ordered, String encoding) {
        BulkOperationResult.BulkOperationResultBuilder result = BulkOperationResult.builder();
        boolean hasAnyError = false;
        boolean hasMongoBulkWriteException = false;
        boolean hasMongoWriteException = false;
        UnmodifiableIterator unmodifiableIterator = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(documents.size() - 1)), (DiscreteDomain)DiscreteDomain.integers()).iterator();
        while (unmodifiableIterator.hasNext()) {
            int index = (Integer)unmodifiableIterator.next();
            BulkItem.BulkItemBuilder item = BulkItem.builder().setPayload((Object)new TypedValue(streamingHelper.resolveCursorProvider((Object)ConverterUtils.toJsonResult(documents.get(index), encoding)), this.JSON_STREAM));
            hasMongoBulkWriteException = this.hasMongoBulkWriteException(e, index, (BulkItem.BulkItemBuilder<TypedValue<InputStream>>)item);
            hasMongoWriteException = this.hasMongoWriteException(e, (BulkItem.BulkItemBuilder<TypedValue<InputStream>>)item);
            boolean bl = hasAnyError = hasMongoBulkWriteException || hasMongoWriteException || hasAnyError;
            if (ordered && hasAnyError && !hasMongoBulkWriteException && !hasMongoWriteException) {
                item.setSuccessful(false);
                item.setMessage(" Error with previous record ");
            }
            result.addItem(item);
        }
        result.setSuccessful(e == null);
        return result.build();
    }

    private boolean hasMongoBulkWriteException(MongoServerException e, int index, BulkItem.BulkItemBuilder<TypedValue<InputStream>> item) {
        boolean hasMongoBulkWriteException = false;
        if (MongoBulkWriteException.class.isInstance(e)) {
            for (BulkWriteError error : ((MongoBulkWriteException)((Object)MongoBulkWriteException.class.cast(e))).getWriteErrors()) {
                if (error.getIndex() != index) continue;
                this.setStatusVars(item, String.valueOf(error.getCode()), error.getMessage(), (Exception)e, false);
                hasMongoBulkWriteException = true;
            }
        }
        return hasMongoBulkWriteException;
    }

    private boolean hasMongoWriteException(MongoServerException e, BulkItem.BulkItemBuilder<TypedValue<InputStream>> item) {
        boolean hasMongoWriteException = false;
        if (MongoWriteException.class.isInstance(e)) {
            for (WriteError error : Collections.singletonList(((MongoWriteException)((Object)MongoWriteException.class.cast(e))).getError())) {
                this.setStatusVars(item, String.valueOf(error.getCode()), error.getMessage(), (Exception)e, false);
            }
            hasMongoWriteException = true;
        }
        return hasMongoWriteException;
    }

    private void setStatusVars(BulkItem.BulkItemBuilder<TypedValue<InputStream>> item, String code, String message, Exception e, boolean successful) {
        item.setStatusCode(code);
        item.setMessage(message);
        item.setException(e);
        item.setSuccessful(successful);
    }

    public long removeObjects(MongoDatabase database, MongoConfig config, String collection, InputStream query) {
        DeleteResult deleteResult = database.getCollection(collection).deleteMany((Bson)ConverterUtils.toNonNullDocument(query, config.getEncoding()));
        return deleteResult.wasAcknowledged() ? deleteResult.getDeletedCount() : -1L;
    }

    public InputStream updateObjects(MongoDatabase database, MongoConfig config, String collection, InputStream query, InputStream document, boolean multi, boolean upsert) {
        UpdateOptions options = new UpdateOptions();
        options.upsert(upsert);
        UpdateResult result = !multi ? database.getCollection(collection).updateOne((Bson)ConverterUtils.toDocument(query, config.getEncoding()), (Bson)ConverterUtils.fromFunction("$set", this.adapt((Map<String, Object>)ConverterUtils.toDocument(document, config.getEncoding()))), options) : database.getCollection(collection).updateMany((Bson)ConverterUtils.toDocument(query, config.getEncoding()), (Bson)ConverterUtils.fromFunction("$set", this.adapt((Map<String, Object>)ConverterUtils.toDocument(document, config.getEncoding()))), options);
        return this.convertPojoToJsonInputStream(new UpdateDocumentResult(result.getMatchedCount(), result.getModifiedCount(), this.convertBsonValueToString(result.getUpsertedId())), config);
    }

    public InputStream executeCommand(MongoDatabase database, InputStream command, String encoding) {
        return ConverterUtils.toJsonResult(database.runCommand((Bson)ConverterUtils.toDocument(command, encoding)), encoding);
    }

    private Bson from(List<String> fieldsList, boolean returnId) {
        Document document = new Document(Maps.asMap((Set)Sets.newHashSet((Iterable)Optional.ofNullable(fieldsList).orElse(Collections.emptyList())), (Function)Functions.constant((Object)true)));
        if (!returnId) {
            document.put("_id", (Object)false);
        }
        return document;
    }

    private InputStream convertPojoToJsonInputStream(Object object, MongoConfig config) {
        if (object != null) {
            try {
                return IOUtils.toInputStream((String)config.getGsonInstance().toJson(object), (String)config.getEncoding());
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return null;
    }

    private Document adapt(Map<String, Object> o) {
        return new Document(o);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Document> convertInputStreamToDocumentList(InputStream documentsInputStream) {
        if (documentsInputStream == null) return Collections.emptyList();
        try (InputStreamReader docsReader = new InputStreamReader(documentsInputStream);){
            LinkedList<Document> documentList = new LinkedList<Document>();
            JsonArray arrayDocuments = (JsonArray)new JsonParser().parse((Reader)docsReader);
            for (JsonElement element : arrayDocuments) {
                documentList.add(ConverterUtils.convertStringToDateFields(Document.parse((String)element.toString())));
            }
            LinkedList<Document> linkedList = documentList;
            return linkedList;
        }
        catch (IOException e) {
            throw new ModuleException(e.getMessage(), (ErrorTypeDefinition)MongoErrorType.CONSISTENCY_ERROR);
        }
    }

    private String convertBsonValueToString(BsonValue bsonValue) {
        if (bsonValue == null) {
            return null;
        }
        if (bsonValue.isObjectId()) {
            return bsonValue.asObjectId().getValue().toString();
        }
        if (bsonValue.isString()) {
            return bsonValue.asString().getValue();
        }
        if (bsonValue.isInt64()) {
            return Long.toString(bsonValue.asInt64().getValue());
        }
        return null;
    }
}

