/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.service.CollectionService;
import com.mulesoft.connector.mongo.internal.service.DocumentService;
import com.mulesoft.connector.mongo.internal.service.callable.BsonDumpWriter;
import com.mulesoft.connector.mongo.internal.service.callable.MongoDirectoryRestorer;
import com.mulesoft.connector.mongo.internal.service.callable.MongoDumpCollection;
import com.mulesoft.connector.mongo.internal.service.callable.MongoFileRestorer;
import com.mulesoft.connector.mongo.internal.service.callable.OplogCollection;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseService {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseService.class);
    private static final String TIMESTAMP_FORMAT = "'.'yyyy-MM-dd-HH-mm";
    private CollectionService collectionService;
    private DocumentService documentService;

    public DatabaseService(CollectionService collectionService, DocumentService documentService) {
        this.collectionService = collectionService;
        this.documentService = documentService;
    }

    public Document addUser(MongoDatabase database, String username, String password) {
        Document command = new Document();
        command.put("createUser", (Object)username);
        command.put("pwd", (Object)password);
        command.put("roles", (Object)ImmutableList.of((Object)"readWrite"));
        return database.runCommand((Bson)command);
    }

    public List<String> dump(MongoDatabase database, String outputDirectory, String outputNamePrefix, boolean oplog, MongoDatabase adminDatabase, MongoDatabase localDatabase, Scheduler scheduler, long schedulerTimeout, TimeUnit schedulerTimeoutTimeUnit) {
        ImmutableMap dbs;
        String databaseWithTimestamp = database.getName();
        ImmutableMap immutableMap = dbs = oplog ? ImmutableMap.builder().put((Object)"admin", (Object)adminDatabase).put((Object)"local", (Object)localDatabase).build() : ImmutableMap.builder().build();
        if (StringUtils.isBlank((String)outputNamePrefix)) {
            outputNamePrefix = database.getName();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMESTAMP_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        databaseWithTimestamp = databaseWithTimestamp + dateFormat.format(System.currentTimeMillis());
        Iterable<String> collections = this.collectionService.listCollections(database);
        ArrayList<String> outputFilesPaths = new ArrayList<String>();
        LinkedList tasks = Lists.newLinkedList();
        if (collections != null) {
            BsonDumpWriter dumpWriter = new BsonDumpWriter(outputDirectory, databaseWithTimestamp, outputNamePrefix);
            for (String collectionName : collections) {
                tasks.add(new MongoDumpCollection(this.collectionService.getCollection(database, collectionName), dumpWriter));
                outputFilesPaths.add(dumpWriter.getFilePath(collectionName));
            }
            if (oplog) {
                MongoCollection<Document> oplogCollection = new OplogCollection((MongoDatabase)dbs.get("admin"), (MongoDatabase)dbs.get("local")).getOplogCollection();
                MongoDumpCollection dumpCollection = new MongoDumpCollection(oplogCollection, dumpWriter);
                dumpCollection.setName("oplog");
                Document query = new Document();
                query.put("ns", (Object)this.getNamespacePattern(database.getName()));
                dumpCollection.setQuery(query);
                dumpCollection.setDumpWriter(dumpWriter);
                tasks.add(dumpCollection);
                outputFilesPaths.add(dumpWriter.getFilePath("oplog"));
            }
            this.executeAll(tasks, scheduler, schedulerTimeout, schedulerTimeoutTimeUnit);
            return outputFilesPaths;
        }
        return Collections.emptyList();
    }

    private Pattern getNamespacePattern(String database) {
        return Pattern.compile("^" + database + ".*");
    }

    private void executeAll(List<Callable<Void>> tasks, Scheduler scheduler, long schedulerTimeout, TimeUnit schedulerTimeoutTimeUnit) {
        try {
            scheduler.invokeAll(tasks, schedulerTimeout, schedulerTimeoutTimeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ModuleException((ErrorTypeDefinition)MongoErrorType.TIMEOUT, (Throwable)e);
        }
    }

    public void restore(MongoDatabase database, String inputPath, boolean dropCollection, boolean oplogReplay, Scheduler scheduler, String encoding) {
        Future future = scheduler.submit(() -> new MongoDirectoryRestorer(database.getName(), dropCollection, oplogReplay, inputPath, this.collectionService, this.documentService).restore(database, encoding));
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            logger.info(e.getMessage(), (Throwable)e);
        }
    }

    public void restoreFromFile(MongoDatabase database, String collectionName, InputStream input, boolean dropCollection) {
        new MongoFileRestorer(collectionName, input, dropCollection, this.collectionService).restoreCollection(database);
    }
}

