/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.service;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mulesoft.connector.mongo.api.Index;
import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.param.CappedOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class CollectionService {
    public Iterable<String> listCollections(MongoDatabase database) {
        return database.listCollectionNames();
    }

    public MongoCollection<Document> getCollection(MongoDatabase database, String collection) {
        return database.getCollection(collection);
    }

    public boolean existsCollection(MongoDatabase database, String collection) {
        return Iterables.tryFind((Iterable)database.listCollectionNames(), (Predicate)Predicates.equalTo((Object)collection)).isPresent();
    }

    public void dropCollection(MongoDatabase database, String collection) {
        if (!this.existsCollection(database, collection)) {
            throw new ModuleException(String.format("The collection %s could not be deleted because it does not exists.", collection), (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
        }
        database.getCollection(collection).drop();
    }

    public void createCollection(MongoDatabase database, String collection, CappedOptions cappedOptions) {
        CreateCollectionOptions options = new CreateCollectionOptions();
        options.capped(cappedOptions.getMaxObjects() != 0 && cappedOptions.getCollectionSize() != 0);
        if (options.isCapped()) {
            if (cappedOptions.getMaxObjects() != 0) {
                options.maxDocuments((long)cappedOptions.getMaxObjects().intValue());
            }
            if (cappedOptions.getCollectionSize() != 0) {
                options.sizeInBytes((long)cappedOptions.getCollectionSizeDataUnit().toBytes(cappedOptions.getCollectionSize().intValue()));
            }
        }
        database.createCollection(collection, options);
    }

    public String createIndex(MongoDatabase database, String collection, String field, IndexOrder order) {
        return database.getCollection(collection).createIndex((Bson)new Document(field, (Object)order.getValue()));
    }

    public void dropIndex(MongoDatabase database, String collection, String name) {
        if (!this.existsCollection(database, collection)) {
            throw new ModuleException("The collection does not exist", (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
        }
        database.getCollection(collection).dropIndex(name);
    }

    public List<Index> listIndexes(MongoDatabase database, String collection) {
        if (this.existsCollection(database, collection)) {
            return this.convertDocumentListToIndexList(Lists.newArrayList((Iterable)database.getCollection(collection).listIndexes()));
        }
        throw new ModuleException("The collection does not exist", (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
    }

    public InputStream mapReduce(MongoDatabase database, MongoConfig config, String collection, String mapFunction, String reduceFunction, String outputCollection) {
        MapReduceIterable mapReduceIterable = database.getCollection(collection).mapReduce(mapFunction, reduceFunction);
        if (outputCollection != null) {
            mapReduceIterable = mapReduceIterable.collectionName(outputCollection);
        }
        return this.convertDocumentListToJsonResult(config, (Iterable<Document>)mapReduceIterable);
    }

    private InputStream convertDocumentListToJsonResult(MongoConfig config, Iterable<Document> documents) {
        try {
            return IOUtils.toInputStream((String)documents.iterator().next().toJson(), (String)config.getEncoding());
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private List<Index> convertDocumentListToIndexList(Collection<Document> documents) {
        LinkedList<Index> indexes = new LinkedList<Index>();
        for (Document document : documents) {
            String name = (String)document.get((Object)"name");
            String fieldName = (String)((Document)document.get((Object)"key", Document.class)).keySet().iterator().next();
            Integer order = (Integer)((Document)document.get((Object)"key", Document.class)).get((Object)fieldName, Integer.class);
            IndexOrder indexOrder = order == 1 ? IndexOrder.ASC : IndexOrder.DESC;
            indexes.add(new Index(name, fieldName, indexOrder));
        }
        return indexes;
    }
}

