/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.pagination;

import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.service.FindObjectsRequest;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.bson.Document;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class PaginatedResult
implements PagingProvider<MongoConnection, TypedValue<InputStream>> {
    private static final DataType JSON_STREAM = DataType.builder().type(InputStream.class).mediaType(MediaType.APPLICATION_JSON).build();
    private FindObjectsRequest request;
    private Iterable<Document> results;
    private Iterator<Document> iterator;
    private int pageSize;
    private boolean firstTime = true;
    private StreamingHelper streamingHelper;
    private MongoConfig config;

    public PaginatedResult(MongoConfig config, FindObjectsRequest request, StreamingHelper streamingHelper) {
        this.request = request;
        this.streamingHelper = streamingHelper;
        this.pageSize = request.getPageSize();
        this.config = config;
    }

    public List<TypedValue<InputStream>> getPage(MongoConnection connection) {
        if (this.firstTime) {
            this.firstTime = false;
            this.results = connection.findDocuments(this.config, this.request);
            this.iterator = this.results.iterator();
        }
        ArrayList<TypedValue<InputStream>> pages = new ArrayList<TypedValue<InputStream>>(this.pageSize);
        for (int i = 0; i < this.pageSize && this.iterator.hasNext(); ++i) {
            pages.add((TypedValue<InputStream>)new TypedValue(this.streamingHelper.resolveCursorProvider((Object)ConverterUtils.toJsonResult(this.iterator.next(), this.config.getEncoding())), JSON_STREAM));
        }
        return pages;
    }

    public Optional<Integer> getTotalResults(MongoConnection connection) {
        return Optional.empty();
    }

    public void close(MongoConnection connection) throws MuleException {
    }
}

