/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.operation;

import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.provider.MongoFileErrorTypeProvider;
import com.mulesoft.connector.mongo.internal.metadata.BinaryMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.CollectionFieldsMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.FileMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.JsonMetadataResolver;
import java.io.InputStream;
import java.util.List;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@Throws(value={MongoFileErrorTypeProvider.class})
public class FileOperations {
    @OutputResolver(output=FileMetadataResolver.class)
    @MediaType(value="application/json")
    public InputStream createFile(@Config MongoConfig config, @Connection MongoConnection connection, @Content(primary=true) @TypeResolver(value=BinaryMetadataResolver.class) InputStream content, String filename, @Optional @Content @TypeResolver(value=JsonMetadataResolver.class) InputStream metadata) {
        return connection.createFile(config, content, filename, metadata);
    }

    @OutputResolver(output=FileMetadataResolver.class)
    public List<TypedValue<InputStream>> findFiles(@Config MongoConfig config, @Connection MongoConnection connection, @Optional @TypeResolver(value=JsonMetadataResolver.class) @Content(primary=true) @Summary(value="The query object used to list all the files.") InputStream query, @Optional @TypeResolver(value=CollectionFieldsMetadataResolver.class) @Content @Summary(value="Allows you to sort the result list. ") InputStream sort, StreamingHelper streamingHelper) {
        return connection.findFiles(config, query, sort, streamingHelper);
    }

    @OutputResolver(output=BinaryMetadataResolver.class, attributes=FileMetadataResolver.class)
    public Result<TypedValue<Object>, TypedValue<InputStream>> getFileContent(@Config MongoConfig config, @Connection MongoConnection connection, @Content @TypeResolver(value=JsonMetadataResolver.class) InputStream fileId, StreamingHelper streamingHelper) {
        return connection.getFileContent(config, fileId, streamingHelper);
    }

    public void removeFiles(@Config MongoConfig config, @Connection MongoConnection connection, @Content @TypeResolver(value=JsonMetadataResolver.class) InputStream fileId) {
        connection.removeFiles(config, fileId);
    }
}

