/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.operation;

import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.provider.MongoDocumentErrorTypeProvider;
import com.mulesoft.connector.mongo.internal.metadata.CollectionFieldsMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.DocMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.ExecuteMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.InsertDocumentsMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.JsonMetadataResolver;
import com.mulesoft.connector.mongo.internal.metadata.UpdateDocumentResultJsonMetadataResolver;
import com.mulesoft.connector.mongo.internal.pagination.PaginatedResult;
import com.mulesoft.connector.mongo.internal.param.CollectionNameAndFields;
import com.mulesoft.connector.mongo.internal.service.FindObjectsRequest;
import com.mulesoft.connector.mongo.internal.util.ConverterUtils;
import com.mulesoft.connector.mongo.internal.valueprovider.WriteConcernValueProvider;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@Throws(value={MongoDocumentErrorTypeProvider.class})
public class DocumentOperations {
    @MediaType(value="application/json")
    @OutputResolver(output=DocMetadataResolver.class)
    public InputStream insertDocument(@Config MongoConfig config, @Connection MongoConnection connection, @MetadataKeyId(value=DocMetadataResolver.class) String collectionName, @TypeResolver(value=DocMetadataResolver.class) @Content InputStream document, @Placement(tab="Advanced", order=0) @OfValues(value=WriteConcernValueProvider.class) @Optional @ConfigOverride String writeConcernAcknowledgement, @Placement(tab="Advanced", order=1) @Optional @ConfigOverride int writeConcernTimeout, @Placement(tab="Advanced", order=2) @Optional @ConfigOverride TimeUnit writeConcernTimeoutTimeunit) {
        return connection.insertDocument(config, collectionName, document);
    }

    @OutputResolver(output=InsertDocumentsMetadataResolver.class)
    public BulkOperationResult<TypedValue<InputStream>> insertDocuments(@Config MongoConfig config, @Connection MongoConnection connection, @MetadataKeyId(value=DocMetadataResolver.class) String collectionName, @TypeResolver(value=InsertDocumentsMetadataResolver.class) @Content InputStream documents, @Placement(tab="Advanced", order=0) @Summary(value="If the list of documents will be executed in order or not") @Optional(defaultValue="false") boolean writeOrdered, @Placement(tab="Advanced", order=1) @OfValues(value=WriteConcernValueProvider.class) @Optional @ConfigOverride String writeConcernAcknowledgement, @Placement(tab="Advanced", order=2) @Optional @ConfigOverride int writeConcernTimeout, @Placement(tab="Advanced", order=3) @Optional @ConfigOverride TimeUnit writeConcernTimeoutTimeunit, StreamingHelper streamingHelper) {
        return connection.insertDocuments(config, collectionName, documents, writeOrdered, streamingHelper);
    }

    @OutputResolver(output=UpdateDocumentResultJsonMetadataResolver.class)
    @MediaType(value="application/json")
    public InputStream updateDocuments(@Config MongoConfig config, @Connection MongoConnection connection, @MetadataKeyId(value=DocMetadataResolver.class) String collectionName, @Optional @Content @Summary(value="The query object used to detect the element to update") @TypeResolver(value=JsonMetadataResolver.class) InputStream query, @TypeResolver(value=DocMetadataResolver.class) @Content(primary=true) InputStream contentToUpdate, @Placement(tab="Advanced", order=0) @Optional boolean multipleUpdate, @Placement(tab="Advanced", order=1) @Optional @Summary(value="Creates a new document when no one matches with the query criteria") boolean upsert, @Placement(tab="Advanced", order=2) @OfValues(value=WriteConcernValueProvider.class) @Optional @ConfigOverride String writeConcernAcknowledgement, @Placement(tab="Advanced", order=3) @Optional @ConfigOverride int writeConcernTimeout, @Placement(tab="Advanced", order=4) @Optional @ConfigOverride TimeUnit writeConcernTimeoutTimeunit) {
        return connection.updateDocuments(config, collectionName, query, contentToUpdate, multipleUpdate, upsert);
    }

    public long removeDocuments(@Config MongoConfig config, @Connection MongoConnection connection, @MetadataKeyId(value=DocMetadataResolver.class) String collectionName, @Optional @Content @Summary(value="The query object used to detect the elements to delete") @TypeResolver(value=JsonMetadataResolver.class) InputStream query) {
        return connection.removeDocuments(config, collectionName, query);
    }

    public long countDocuments(@Config MongoConfig config, @Connection MongoConnection connection, @MetadataKeyId(value=DocMetadataResolver.class) String collectionName, @Optional @Content @Summary(value="The optional query for counting documents") @TypeResolver(value=JsonMetadataResolver.class) InputStream query, @Placement(tab="Advanced", order=0) @OfValues(value=WriteConcernValueProvider.class) @Optional @ConfigOverride String writeConcernAcknowledgement, @Placement(tab="Advanced", order=1) @Optional @ConfigOverride int writeConcernTimeout, @Placement(tab="Advanced", order=2) @Optional @ConfigOverride TimeUnit writeConcernTimeoutTimeunit) {
        return connection.countDocuments(config, collectionName, query);
    }

    @OutputResolver(output=CollectionFieldsMetadataResolver.class)
    public PagingProvider<MongoConnection, TypedValue<InputStream>> findDocuments(@Config MongoConfig config, @ParameterGroup(name="Collection and fields") @MetadataKeyId(value=CollectionFieldsMetadataResolver.class) CollectionNameAndFields collectionNameAndFields, @Optional @Content(primary=true) @Summary(value="The optional query for finding documents") @TypeResolver(value=JsonMetadataResolver.class) InputStream query, @Optional @Content @TypeResolver(value=CollectionFieldsMetadataResolver.class) InputStream sortBy, @Optional(defaultValue="100") @Placement(tab="Advanced") int pageSize, @Placement(tab="Advanced", order=0) @Optional int limit, @Placement(tab="Advanced", order=1) @OfValues(value=WriteConcernValueProvider.class) @Optional @ConfigOverride String writeConcernAcknowledgement, @Placement(tab="Advanced", order=2) @Optional @ConfigOverride int writeConcernTimeout, @Placement(tab="Advanced", order=3) @Optional @ConfigOverride TimeUnit writeConcernTimeoutTimeunit, StreamingHelper streamingHelper) {
        return new PaginatedResult(config, new FindObjectsRequest(collectionNameAndFields.getCollectionName(), query, collectionNameAndFields.getFields(), (Integer)pageSize, (Integer)limit, ConverterUtils.toJsonResult(ConverterUtils.fromSortByJsonToDocument(sortBy, config.getEncoding()), config.getEncoding()), true, config.getEncoding()), streamingHelper);
    }

    @MediaType(value="application/json")
    @OutputResolver(output=ExecuteMetadataResolver.class)
    public InputStream executeCommand(@Config MongoConfig config, @Connection MongoConnection connection, @Example(value="{\"delete\": \"testDeleteCollection\",\"deletes\": [{\"q\": {},\"limit\": 1}]}") @Content @TypeResolver(value=JsonMetadataResolver.class) InputStream command) {
        return connection.executeCommand(config, command);
    }
}

