/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.operation;

import com.google.common.collect.ImmutableList;
import com.mulesoft.connector.mongo.api.Index;
import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.provider.MongoCollectionErrorTypeProvider;
import com.mulesoft.connector.mongo.internal.metadata.JsonMetadataResolver;
import com.mulesoft.connector.mongo.internal.param.CappedOptions;
import com.mulesoft.connector.mongo.internal.valueprovider.CollectionsValueProvider;
import com.mulesoft.connector.mongo.internal.valueprovider.FieldValueProvider;
import com.mulesoft.connector.mongo.internal.valueprovider.IndexValueProvider;
import java.io.InputStream;
import java.util.List;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.annotation.values.OfValues;

@Throws(value={MongoCollectionErrorTypeProvider.class})
public class CollectionOperations {
    public void createCollection(@Config MongoConfig config, @Connection MongoConnection connection, String collectionName, @Placement(tab="Advanced") @Summary(value="Parameters to setup collection capping.") @ParameterGroup(showInDsl=true, name="Capped Options") CappedOptions cappedOptions) {
        connection.createCollection(config, collectionName, cappedOptions);
    }

    public void dropCollection(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName) {
        connection.dropCollection(config, collectionName);
    }

    public boolean collectionExists(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName) {
        return connection.existsCollection(config, collectionName);
    }

    public List<String> listCollections(@Config MongoConfig config, @Connection MongoConnection connection) {
        return ImmutableList.copyOf(connection.listCollections(config));
    }

    @OutputResolver(output=JsonMetadataResolver.class)
    @MediaType(value="application/json")
    public InputStream mapReduce(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName, @Text @Example(value="function() {emit(this.cust_id, this.amount);}") String mappingFunction, @Text @Example(value="function(key,values) {return Array.sum(values);}") String reduceFunction, @Placement(tab="Advanced", order=1) @Summary(value="Name of the output collection to write results") @Optional String outputCollection) {
        return connection.mapReduce(config, collectionName, mappingFunction, reduceFunction, outputCollection);
    }

    @MediaType(value="application/plain")
    public String createIndex(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName, @OfValues(value=FieldValueProvider.class) String fieldName, @Optional(defaultValue="ASC") @Summary(value="Indicates the indexing order ASC or DESC") IndexOrder sortOrder) {
        return connection.createIndex(config, collectionName, fieldName, sortOrder);
    }

    public void dropIndex(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName, @OfValues(value=IndexValueProvider.class) String indexName) {
        connection.dropIndex(config, collectionName, indexName);
    }

    public List<Index> listIndexes(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName) {
        return connection.listIndexes(config, collectionName);
    }
}

