/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.operation;

import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.provider.MongoAdvancedErrorTypeProvider;
import com.mulesoft.connector.mongo.internal.metadata.BinaryMetadataResolver;
import com.mulesoft.connector.mongo.internal.valueprovider.CollectionsValueProvider;
import com.mulesoft.connector.mongo.internal.valueprovider.DatabaseValueProvider;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;

@Throws(value={MongoAdvancedErrorTypeProvider.class})
public class AdvancedOperations {
    public void addUser(@Config MongoConfig config, @Connection MongoConnection connection, String username, @Password String password) {
        connection.addUser(config, username, password);
    }

    public void dropDatabase(@Config MongoConfig config, @Connection MongoConnection connection, @Example(value="aDatabaseName") @OfValues(value=DatabaseValueProvider.class) String databaseName) {
        connection.dropDatabase(config, databaseName);
    }

    public List<String> dump(@Config MongoConfig config, @Connection MongoConnection connection, @Path(type=PathModel.Type.DIRECTORY, location=PathModel.Location.EXTERNAL) String outputDirectory, @Optional @Example(value="2020-01-01-backup") String outputNamePrefix, @Placement(tab="Advanced") @Optional boolean oplog, @Placement(tab="Advanced") @Optional(defaultValue="60") long operationTimeout, @Placement(tab="Advanced") @Optional(defaultValue="SECONDS") TimeUnit operationTimeoutUnit) {
        return connection.dump(config, outputDirectory, outputNamePrefix, oplog, operationTimeout, operationTimeoutUnit);
    }

    public void restoreFromDirectory(@Config MongoConfig config, @Connection MongoConnection connection, @Path(type=PathModel.Type.DIRECTORY, location=PathModel.Location.EXTERNAL) @Example(value="/Users/user/folder/dumps") String inputPath, @Optional boolean dropCollections, @Optional @Placement(tab="Advanced") boolean oplogReplay) {
        connection.restoreFromDirectory(config, inputPath, dropCollections, oplogReplay);
    }

    public void restoreFromFile(@Config MongoConfig config, @Connection MongoConnection connection, @OfValues(value=CollectionsValueProvider.class) String collectionName, @Summary(value="An InputStream that points to the dump file. It can be a zip file or just a bson file\n") @Content @TypeResolver(value=BinaryMetadataResolver.class) InputStream input, @Optional boolean dropCollection) {
        connection.restoreFromFile(config, collectionName, input, dropCollection);
    }
}

