/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mongodb.client.MongoCursor;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.service.FindObjectsRequest;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;

public class DocMetadataRetriever {
    private static final Integer DEFAULT_DOCUMENT_SAMPLE_SIZE = 1;
    private static final Supplier<BaseTypeBuilder> JSON_TYPE_BUILDER = () -> new BaseTypeBuilder(JsonTypeLoader.JSON);
    private static final Map<Class<?>, MetadataType> DATA_TYPE_MAPPING = ImmutableMap.builder().put(Integer.class, (Object)JSON_TYPE_BUILDER.get().numberType().build()).put(Long.class, (Object)JSON_TYPE_BUILDER.get().numberType().build()).put(Boolean.class, (Object)JSON_TYPE_BUILDER.get().booleanType().build()).put(String.class, (Object)JSON_TYPE_BUILDER.get().stringType().build()).put(Float.class, (Object)JSON_TYPE_BUILDER.get().numberType().build()).put(Double.class, (Object)JSON_TYPE_BUILDER.get().numberType().build()).put(Date.class, (Object)JSON_TYPE_BUILDER.get().dateTimeType().build()).put(Object.class, (Object)JSON_TYPE_BUILDER.get().objectType().build()).build();
    private MongoConfig config;
    private MongoConnection connection;

    public DocMetadataRetriever(Optional<MongoConnection> connection, Optional<MongoConfig> config) {
        this.config = config.get();
        this.connection = connection.get();
    }

    public Set<MetadataKey> getKeys() {
        return StreamSupport.stream(this.connection.listCollections(this.config).spliterator(), false).map(key -> MetadataKeyBuilder.newKey((String)key).build()).collect(Collectors.toSet());
    }

    public MetadataType getMetadata(String key) {
        MongoCursor documents = this.connection.findDocuments(this.config, new FindObjectsRequest(key, Document.parse((String)"{}"), (List<String>)ImmutableList.builder().build(), null, DEFAULT_DOCUMENT_SAMPLE_SIZE, Document.parse((String)"{$natural:-1}"), true)).iterator();
        if (!documents.hasNext()) {
            return this.getGenericMetadata();
        }
        BaseTypeBuilder baseBuilder = JSON_TYPE_BUILDER.get();
        ObjectTypeBuilder objectTypeBuilder = baseBuilder.objectType().id("Document");
        return this.buildMetadata(baseBuilder, objectTypeBuilder, (Map)documents.next());
    }

    private MetadataType buildMetadata(BaseTypeBuilder baseTypeBuilder, ObjectTypeBuilder parentTypeBuilder, Map<String, Object> document) {
        document.forEach((k, v) -> {
            ObjectFieldTypeBuilder objectFieldTypeBuilder = parentTypeBuilder.addField().key(k);
            if (v instanceof Map) {
                ObjectTypeBuilder objectTypeBuilder = baseTypeBuilder.objectType();
                objectFieldTypeBuilder.value(this.buildMetadata(baseTypeBuilder, objectTypeBuilder, (Map)v));
            } else if (v instanceof List) {
                List listField = (List)v;
                BaseTypeBuilder arrayTypeBuilder = baseTypeBuilder.arrayType().of();
                if (listField.isEmpty()) {
                    objectFieldTypeBuilder.value((TypeBuilder)arrayTypeBuilder.anyType());
                } else if (Map.class.isInstance(listField.get(0).getClass())) {
                    ObjectTypeBuilder objectTypeBuilder = baseTypeBuilder.objectType();
                    this.buildMetadata(arrayTypeBuilder, objectTypeBuilder, (Map)listField.get(0));
                } else {
                    MetadataType type = DATA_TYPE_MAPPING.get(listField.get(0).getClass());
                    objectFieldTypeBuilder.value((TypeBuilder)baseTypeBuilder.arrayType().of(type));
                }
            } else {
                MetadataType type = DATA_TYPE_MAPPING.get(v.getClass());
                if (type == null && v instanceof ObjectId) {
                    type = JSON_TYPE_BUILDER.get().objectType().build();
                }
                objectFieldTypeBuilder.value(type).build();
            }
        });
        return parentTypeBuilder.build();
    }

    private MetadataType getGenericMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JSON).withFormat(JsonTypeLoader.JSON).objectType().build();
    }
}

