/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.metadata;

import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.extension.MongoConnector;
import com.mulesoft.connector.mongo.internal.metadata.DocMetadataResolver;
import com.mulesoft.connector.mongo.internal.param.CollectionNameAndFields;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.extension.api.annotation.param.Config;

public class CollectionFieldsMetadataResolver
implements TypeKeysResolver,
OutputTypeResolver<CollectionNameAndFields>,
InputTypeResolver<CollectionNameAndFields> {
    private static final String NAME_REGEX_PATTERN = "[a-zA-Z0-9]+.*";
    @Config
    private MongoConfig config;

    public MetadataType getOutputType(MetadataContext context, CollectionNameAndFields key) throws MetadataResolvingException, ConnectionException {
        return this.wrapInArrayType(new DocMetadataResolver().getOutputType(context, key.getCollectionName()), JsonTypeLoader.JSON);
    }

    public String getCategoryName() {
        return MongoConnector.class.getName();
    }

    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> setOfKeys = new HashSet<MetadataKey>();
        MongoConnection connection = (MongoConnection)context.getConnection().get();
        for (String collectionName : connection.listCollections(this.config)) {
            MetadataKeyBuilder collectionKey = MetadataKeyBuilder.newKey((String)collectionName);
            collectionKey.withChild(MetadataKeyBuilder.newKey((String)",").withDisplayName("All fields"));
            setOfKeys.add(collectionKey.build());
        }
        return setOfKeys;
    }

    public String getResolverName() {
        return CollectionFieldsMetadataResolver.class.getName();
    }

    public MetadataType getInputMetadata(MetadataContext context, CollectionNameAndFields key) throws MetadataResolvingException, ConnectionException {
        Pattern pattern = Pattern.compile(NAME_REGEX_PATTERN);
        ObjectTypeBuilder object = BaseTypeBuilder.create((MetadataFormat)JsonTypeLoader.JSON).objectType();
        object.addField().key(pattern).value().stringType().enumOf(new String[]{IndexOrder.ASC.name(), IndexOrder.DESC.name()});
        ObjectType objectBuilt = object.build();
        return BaseTypeBuilder.create((MetadataFormat)JsonTypeLoader.JSON).arrayType().of((MetadataType)objectBuilt).build();
    }

    private MetadataType wrapInArrayType(MetadataType value, MetadataFormat format) {
        return new BaseTypeBuilder(format).arrayType().of(value).build();
    }
}

