/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.error;

import com.google.common.collect.ImmutableMap;
import com.mongodb.BulkWriteException;
import com.mongodb.DuplicateKeyException;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoCursorNotFoundException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoNodeIsRecoveringException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoSocketClosedException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoSocketWriteException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;

public class MongoInternalExceptionHandler {
    private static final ImmutableMap<Class<? extends MongoException>, MongoErrorType> ERROR_MAP = ImmutableMap.builder().put(MongoTimeoutException.class, (Object)MongoErrorType.TIMEOUT).put(MongoExecutionTimeoutException.class, (Object)MongoErrorType.TIMEOUT).put(MongoSocketReadTimeoutException.class, (Object)MongoErrorType.TIMEOUT).put(MongoSecurityException.class, (Object)MongoErrorType.PERMISSIONS_DENIED).put(MongoWriteConcernException.class, (Object)MongoErrorType.CONSISTENCY_ERROR).put(MongoBulkWriteException.class, (Object)MongoErrorType.INVALID_INPUT).put(BulkWriteException.class, (Object)MongoErrorType.INVALID_INPUT).put(MongoWriteException.class, (Object)MongoErrorType.INVALID_INPUT).put(MongoQueryException.class, (Object)MongoErrorType.INVALID_INPUT).put(MongoCursorNotFoundException.class, (Object)MongoErrorType.INVALID_INPUT).put(MongoCommandException.class, (Object)MongoErrorType.INVALID_INPUT).put(DuplicateKeyException.class, (Object)MongoErrorType.DUPLICATE_ERROR).put(MongoNodeIsRecoveringException.class, (Object)MongoErrorType.CONNECTIVITY).put(MongoSocketException.class, (Object)MongoErrorType.CONNECTIVITY).put(MongoSocketClosedException.class, (Object)MongoErrorType.CONNECTIVITY).put(MongoSocketOpenException.class, (Object)MongoErrorType.CONNECTIVITY).put(MongoSocketWriteException.class, (Object)MongoErrorType.CONNECTIVITY).put(MongoInterruptedException.class, (Object)MongoErrorType.CONNECTIVITY).build();

    public MongoErrorType get(Class<? extends Exception> exception) {
        return (MongoErrorType)((Object)ERROR_MAP.get(exception));
    }
}

