/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.error;

import com.mongodb.MongoSocketOpenException;
import com.mongodb.MongoWriteException;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.error.MongoInternalExceptionHandler;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class MongoExceptionHandler
extends ExceptionHandler {
    public Exception enrichException(Exception e) {
        MongoErrorType errorType = new MongoInternalExceptionHandler().get(e.getClass());
        if (e instanceof MongoWriteException && ExceptionUtils.getRootCauseMessage((Throwable)e).contains("duplicate key error")) {
            return new ModuleException((ErrorTypeDefinition)MongoErrorType.DUPLICATE_ERROR, (Throwable)e);
        }
        if (e instanceof MongoSocketOpenException && ExceptionUtils.getRootCauseMessage((Throwable)e).contains("timed out")) {
            return new ModuleException((ErrorTypeDefinition)MongoErrorType.TIMEOUT, (Throwable)e);
        }
        if (e instanceof ModuleException) {
            return e;
        }
        if (errorType == MongoErrorType.CONNECTIVITY) {
            return new ConnectionException((Throwable)e);
        }
        if (errorType != null) {
            return new ModuleException((ErrorTypeDefinition)errorType, (Throwable)e);
        }
        return new MuleRuntimeException((Throwable)e);
    }
}

