/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection.provider;

import com.mulesoft.connector.mongo.api.AuthenticationMechanism;
import com.mulesoft.connector.mongo.api.ServerAddress;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.connection.MongoConnectionBuilder;
import com.mulesoft.connector.mongo.internal.connection.provider.AbstractConnectionProvider;
import com.mulesoft.connector.mongo.internal.model.MongoClientInternal;
import com.mulesoft.connector.mongo.internal.param.PoolingProfile;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ExternalLib(name="MongoDB Driver", description="The Java MongoDB Driver that support connections to MongoDB Database", nameRegexpMatcher="mongo(?:db)?-(?:java|driver)-(?:driver|legacy)-(?:3|4)\\.\\d+\\.\\d+\\.jar", requiredClassName="com.mongodb.MongoClient", coordinates="org.mongodb:mongodb-driver-legacy:4.0.4", type=ExternalLibraryType.JAR)
@Alias(value="connection")
public class GenericConnectionProvider
extends AbstractConnectionProvider {
    @Parameter
    @DisplayName(value="Servers (host:port)")
    private List<ServerAddress> serverAddresses;
    @Parameter
    @Example(value="db1")
    private String database;
    @Parameter
    @Optional
    @Example(value="userName")
    private String username;
    @Parameter
    @Optional
    @Password
    @Example(value="password123")
    private String password;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Example(value="replicaSet1")
    private String replicaSetName;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Example(value="$external")
    private String authenticationSource;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="List of compressors to enable network compression for communication between this client and a mongod/mongos instance. If you specify multiple compressors, then the order in which you list the compressors matter as well as the communication initiator.")
    @NullSafe
    private List<String> compressors;
    @Parameter
    @Optional(defaultValue="-1")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int zlibCompressionLevel;
    @Parameter
    @Optional(defaultValue="30")
    @Placement(tab="Advanced")
    @Example(value="30")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int connectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Example(value="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit connectionTimeoutTimeunit;
    @ParameterGroup(name="Pooling Settings", showInDsl=true)
    @Placement(tab="Advanced")
    private PoolingProfile poolingProfile;
    @Parameter
    @Optional(defaultValue="15")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int localThreshold;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit localThresholdTimeUnit;
    @Parameter
    @Optional(defaultValue="30")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int serverSelectionTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit serverSelectionTimeoutTimeUnit;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int socketTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit socketTimeoutUnit;
    @Parameter
    @Optional
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean retryWrites;
    @Parameter
    @Optional
    @Placement(tab="Advanced", order=1)
    @Example(value="PLAIN")
    private AuthenticationMechanism authenticationMechanism;

    public MongoConnection connect() {
        return new MongoConnection(this.database, this.getClientInternal().getClient(), this.getScheduler());
    }

    public void disconnect(MongoConnection connection) {
        connection.disconnect();
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            super.initialise();
            this.setClientInternal(new MongoClientInternal(new MongoConnectionBuilder().withConnectionTimeout(Math.toIntExact(this.connectionTimeoutTimeunit.toMillis(this.connectionTimeout))).withCredentials(this.username, this.password, this.database, this.authenticationMechanism, this.authenticationSource).withHosts(this.serverAddresses).withInvalidHostNameAllowed(Boolean.parseBoolean(System.getProperty("sslInvalidHostNameAllowed", "false"))).withSocketTimeout(Math.toIntExact(this.socketTimeoutUnit.toMillis(this.socketTimeout))).withRetryWrites(this.retryWrites).withTlsContext(this.getTlsContextFactory()).withReplicaSetName(this.replicaSetName).withCompressors(this.compressors, this.zlibCompressionLevel).withPoolingProfile(this.poolingProfile).withLocalThreshold((int)this.localThresholdTimeUnit.toMillis(this.localThreshold)).withServerSelectionTimeout((int)this.serverSelectionTimeoutTimeUnit.toMillis(this.serverSelectionTimeout)).createClient()));
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }
}

