/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection.provider;

import com.mulesoft.connector.mongo.internal.connection.MongoClientURIBuilder;
import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.connection.provider.AbstractConnectionProvider;
import com.mulesoft.connector.mongo.internal.model.MongoClientInternal;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@ExternalLib(name="MongoDB Driver", description="The Java MongoDB Driver that support connections to MongoDB Database", nameRegexpMatcher="mongo(?:db)?-(?:java|driver)-(?:driver|legacy)-(?:3|4)\\.\\d+\\.\\d+\\.jar", requiredClassName="com.mongodb.MongoClient", coordinates="org.mongodb:mongodb-driver-legacy:4.0.4", type=ExternalLibraryType.JAR)
@Alias(value="connection-string")
public class ConnectionStringConnectionProvider
extends AbstractConnectionProvider {
    private MongoClientURIBuilder mongoClientURIBuilder;
    @Expression(value=ExpressionSupport.SUPPORTED)
    @Parameter
    private String connectionString;

    public MongoConnection connect() {
        return new MongoConnection(this.getDatabase(), this.getClientInternal().getClient(), this.getScheduler());
    }

    public void disconnect(MongoConnection connection) {
        connection.disconnect();
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            super.initialise();
            this.mongoClientURIBuilder = new MongoClientURIBuilder().withConnectionString(this.connectionString).withTlsContext(this.getTlsContextFactory());
            this.setClientInternal(new MongoClientInternal(this.mongoClientURIBuilder.build()));
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    private String getDatabase() {
        return this.mongoClientURIBuilder.getDatabase();
    }
}

