/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection.provider;

import com.mulesoft.connector.mongo.internal.connection.MongoConnection;
import com.mulesoft.connector.mongo.internal.error.exception.MongoValidationException;
import com.mulesoft.connector.mongo.internal.model.MongoClientInternal;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public abstract class AbstractConnectionProvider
implements ConnectionProvider<MongoConnection>,
Initialisable,
Disposable {
    static final int DEFAULT_MAXIMUM_THREADS = 5;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    private MongoClientInternal clientInternal;
    @Parameter
    @Optional
    @Placement(tab="Security")
    private TlsContextFactory tlsContextFactory;

    public void initialise() throws InitialisationException {
        this.scheduler = this.getSchedulerService().ioScheduler(SchedulerConfig.config().withMaxConcurrentTasks(5));
        LifecycleUtils.initialiseIfNeeded((Object)this.getTlsContextFactory());
    }

    public void dispose() {
        this.clientInternal.getClient().close();
        this.scheduler.shutdown();
    }

    public ConnectionValidationResult validate(MongoConnection connection) {
        try {
            connection.validate();
            return ConnectionValidationResult.success();
        }
        catch (MongoValidationException e) {
            return ConnectionValidationResult.failure((String)"Connection is no longer valid", (Exception)((Object)e));
        }
    }

    protected SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    protected Scheduler getScheduler() {
        return this.scheduler;
    }

    public MongoClientInternal getClientInternal() {
        return this.clientInternal;
    }

    public void setClientInternal(MongoClientInternal clientInternal) {
        this.clientInternal = clientInternal;
    }

    public TlsContextFactory getTlsContextFactory() {
        return this.tlsContextFactory;
    }
}

