/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCompressor;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mulesoft.connector.mongo.api.AuthenticationMechanism;
import com.mulesoft.connector.mongo.internal.param.PoolingProfile;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.tls.TlsContextFactory;

public class MongoConnectionBuilder {
    private final MongoClientOptions.Builder options = MongoClientOptions.builder();
    private MongoCredential credentials = null;
    private final List<ServerAddress> addresses = new ArrayList<ServerAddress>();

    public MongoConnectionBuilder withHosts(List<com.mulesoft.connector.mongo.api.ServerAddress> hosts) {
        ArrayList serverAddresses = new ArrayList();
        hosts.forEach(host -> serverAddresses.add(new ServerAddress(host.getHost(), host.getPort())));
        this.addresses.addAll(serverAddresses);
        return this;
    }

    public MongoConnectionBuilder withCredentials(String username, String password, String database, AuthenticationMechanism authenticationMechanism, String authenticationSource) {
        if (authenticationSource != null) {
            database = authenticationSource;
        }
        if (!StringUtils.isBlank((String)username) || !StringUtils.isBlank((String)password)) {
            if (authenticationMechanism != null) {
                switch (authenticationMechanism) {
                    case PLAIN: {
                        this.credentials = MongoCredential.createPlainCredential((String)username, (String)database, (char[])password.toCharArray());
                        break;
                    }
                    case SCRAM_SHA_1: {
                        this.credentials = MongoCredential.createScramSha1Credential((String)username, (String)database, (char[])password.toCharArray());
                        break;
                    }
                    case SCRAM_SHA_256: {
                        this.credentials = MongoCredential.createScramSha256Credential((String)username, (String)database, (char[])password.toCharArray());
                        break;
                    }
                }
            } else {
                this.credentials = MongoCredential.createCredential((String)username, (String)database, (char[])password.toCharArray());
            }
        }
        return this;
    }

    public MongoConnectionBuilder withConnectionTimeout(Integer value) {
        this.options.connectTimeout(value.intValue());
        return this;
    }

    public MongoConnectionBuilder withSocketTimeout(Integer value) {
        this.options.socketTimeout(value.intValue());
        return this;
    }

    public MongoConnectionBuilder withTlsContext(TlsContextFactory tlsContextFactory) throws ConnectionException {
        if (tlsContextFactory instanceof Initialisable) {
            try {
                SSLContext sslContext = tlsContextFactory.createSslContext();
                this.options.sslEnabled(true);
                this.options.sslContext(sslContext);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new ConnectionException("Error initializing TLS Context", (Throwable)e);
            }
        }
        return this;
    }

    public MongoConnectionBuilder withInvalidHostNameAllowed(boolean value) {
        this.options.sslInvalidHostNameAllowed(value);
        return this;
    }

    public MongoConnectionBuilder withRetryWrites(boolean retryWrites) {
        this.options.retryWrites(retryWrites);
        return this;
    }

    public MongoConnectionBuilder withReplicaSetName(String replicaSetName) {
        this.options.requiredReplicaSetName(replicaSetName);
        return this;
    }

    public MongoConnectionBuilder withCompressors(List<String> compressors, int zlibCompressorLevel) {
        if (compressors == null) {
            return this;
        }
        ArrayList mongoCompressors = new ArrayList();
        compressors.forEach(compressor -> {
            switch (compressor) {
                case "zlib": {
                    mongoCompressors.add(MongoCompressor.createZlibCompressor().withProperty("level", (Object)zlibCompressorLevel));
                    break;
                }
                case "zstd": {
                    mongoCompressors.add(MongoCompressor.createZstdCompressor());
                    break;
                }
                case "snappy": {
                    mongoCompressors.add(MongoCompressor.createSnappyCompressor());
                    break;
                }
            }
        });
        this.options.compressorList(mongoCompressors);
        return this;
    }

    public MongoConnectionBuilder withPoolingProfile(PoolingProfile poolingProfile) {
        this.options.minConnectionsPerHost(poolingProfile.getMinConnectionPoolSize());
        this.options.connectionsPerHost(poolingProfile.getMaxConnectionPoolSize());
        this.options.maxWaitTime((int)poolingProfile.getMaxWaitQueueTimeUnit().toMillis(poolingProfile.getMaxWaitQueueTime()));
        this.options.maxConnectionLifeTime((int)poolingProfile.getMaxConnectionLifeTimeUnit().toMillis(poolingProfile.getMaxConnectionLifeTime()));
        this.options.maxConnectionIdleTime((int)poolingProfile.getMaxConnectionIdleTimeUnit().toMillis(poolingProfile.getMaxConnectionIdleTime()));
        return this;
    }

    public MongoConnectionBuilder withLocalThreshold(int localThreshold) {
        this.options.localThreshold(localThreshold);
        return this;
    }

    public MongoConnectionBuilder withServerSelectionTimeout(int serverSelectionTimeout) {
        this.options.serverSelectionTimeout(serverSelectionTimeout);
        return this;
    }

    public MongoClient createClient() {
        if (this.credentials != null) {
            return new MongoClient(this.addresses, this.credentials, this.options.build());
        }
        return new MongoClient(this.addresses, this.options.build());
    }
}

