/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoSecurityException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.Tag;
import com.mongodb.TagSet;
import com.mongodb.WriteConcern;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoDatabase;
import com.mulesoft.connector.mongo.api.Index;
import com.mulesoft.connector.mongo.api.IndexOrder;
import com.mulesoft.connector.mongo.api.ReadPreferenceTag;
import com.mulesoft.connector.mongo.internal.config.MongoConfig;
import com.mulesoft.connector.mongo.internal.error.MongoErrorType;
import com.mulesoft.connector.mongo.internal.error.exception.MongoValidationException;
import com.mulesoft.connector.mongo.internal.param.CappedOptions;
import com.mulesoft.connector.mongo.internal.service.CollectionService;
import com.mulesoft.connector.mongo.internal.service.DatabaseService;
import com.mulesoft.connector.mongo.internal.service.DocumentService;
import com.mulesoft.connector.mongo.internal.service.FileService;
import com.mulesoft.connector.mongo.internal.service.FindObjectsRequest;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class MongoConnection
implements ConnectorConnection {
    private static final String OK_KEY = "ok";
    private final MongoClient client;
    private final String databaseName;
    private CollectionService collectionService;
    private DocumentService documentService;
    private DatabaseService databaseService;
    private FileService fileService;
    private Scheduler dumpAndRestoreScheduler;

    public MongoConnection(String database, MongoClient client, Scheduler dumpAndRestoreScheduler) {
        this.databaseName = database;
        this.client = client;
        this.dumpAndRestoreScheduler = dumpAndRestoreScheduler;
        this.collectionService = new CollectionService();
        this.documentService = new DocumentService(this.collectionService);
        this.databaseService = new DatabaseService(this.collectionService, this.documentService);
        this.fileService = new FileService();
    }

    public void validate() {
        try {
            if (!this.isCommandResultOk(this.client.getDatabase(this.databaseName).runCommand((Bson)new BasicDBObject("ping", (Object)"1")))) {
                throw new MongoValidationException(MongoErrorType.CONNECTIVITY);
            }
        }
        catch (MongoCommandException | MongoSecurityException e) {
            throw new MongoValidationException(MongoErrorType.CONNECTIVITY);
        }
    }

    private boolean isCommandResultOk(Document document) {
        return document.containsKey((Object)OK_KEY) && Double.valueOf(document.get((Object)OK_KEY).toString()) == 1.0;
    }

    public void disconnect() {
    }

    public void createCollection(MongoConfig config, String collectionName, CappedOptions cappedOptions) {
        this.collectionService.createCollection(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName, cappedOptions);
    }

    public void dropCollection(MongoConfig config, String collectionName) {
        this.collectionService.dropCollection(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName);
    }

    public boolean existsCollection(MongoConfig config, String collectionName) {
        return this.collectionService.existsCollection(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName);
    }

    public Iterable<String> listCollections(MongoConfig config) {
        return this.collectionService.listCollections(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config));
    }

    public InputStream mapReduce(MongoConfig config, String collectionName, String mappingFunction, String reduceFuntion, String outputCollection) {
        return this.collectionService.mapReduce(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config, collectionName, mappingFunction, reduceFuntion, outputCollection);
    }

    public String createIndex(MongoConfig config, String collectionName, String fieldName, IndexOrder order) {
        return this.collectionService.createIndex(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName, fieldName, order);
    }

    public void dropIndex(MongoConfig config, String collectionName, String indexName) {
        this.collectionService.dropIndex(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName, indexName);
    }

    public List<Index> listIndexes(MongoConfig config, String collectionName) {
        return this.collectionService.listIndexes(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName);
    }

    public InputStream insertDocument(MongoConfig config, String collectionName, InputStream document) {
        return this.documentService.insertObject(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName, document, config.getEncoding());
    }

    public BulkOperationResult<TypedValue<InputStream>> insertDocuments(MongoConfig config, String collectionName, InputStream documents, boolean writeOrdered, StreamingHelper streamingHelper) {
        return this.documentService.insertDocuments(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config, collectionName, documents, writeOrdered, streamingHelper);
    }

    public InputStream updateDocuments(MongoConfig config, String collectionName, InputStream findQuery, InputStream contentToUpdate, boolean multipleUpdate, boolean upsert) {
        return this.documentService.updateObjects(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config, collectionName, findQuery, contentToUpdate, multipleUpdate, upsert);
    }

    public long removeDocuments(MongoConfig config, String collectionName, InputStream findQuery) {
        return this.documentService.removeObjects(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config, collectionName, findQuery);
    }

    public long countDocuments(MongoConfig config, String collectionName, InputStream conditionQuery) {
        return this.documentService.countObjects(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config.getEncoding(), collectionName, conditionQuery);
    }

    public InputStream executeCommand(MongoConfig config, InputStream command) {
        return this.documentService.executeCommand(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), command, config.getEncoding());
    }

    public FindIterable<Document> findObjects(MongoConfig config, String collection, InputStream query, List<String> fields, Integer numToSkip, Integer limit, InputStream sortBy) {
        return this.documentService.findObjects(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), config, collection, query, fields, numToSkip, limit, sortBy);
    }

    public FindIterable<Document> findDocuments(MongoConfig config, FindObjectsRequest request) {
        return this.documentService.findObjectsByRequest(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), request);
    }

    public void addUser(MongoConfig config, String username, String password) {
        this.databaseService.addUser(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), username, password);
    }

    public void dropDatabase(MongoConfig config, String databaseName) {
        if (!this.existsDatabase(databaseName)) {
            throw new ModuleException("Database does not exist", (ErrorTypeDefinition)MongoErrorType.NOT_FOUND);
        }
        this.setDatabaseSettings(this.client.getDatabase(databaseName), config).drop();
    }

    private boolean existsDatabase(String databaseName) {
        return StreamSupport.stream(this.client.listDatabaseNames().spliterator(), false).anyMatch(databaseName::equals);
    }

    public Iterable<String> listDatabases() {
        return this.client.listDatabaseNames();
    }

    public List<String> dump(MongoConfig config, String outputDirectory, String outputNamePrefix, boolean oplog, long schedulerTimeOut, TimeUnit schedulerTimeoutTimeUnit) {
        return this.databaseService.dump(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), outputDirectory, outputNamePrefix, oplog, this.client.getDatabase("admin"), this.client.getDatabase("local"), this.dumpAndRestoreScheduler, schedulerTimeOut, schedulerTimeoutTimeUnit);
    }

    public void restoreFromDirectory(MongoConfig config, String inputPath, boolean dropCollection, boolean oplogReplay) {
        this.databaseService.restore(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), inputPath, dropCollection, oplogReplay, this.dumpAndRestoreScheduler, config.getEncoding());
    }

    public void restoreFromFile(MongoConfig config, String collectionName, InputStream input, boolean dropCollection) {
        this.databaseService.restoreFromFile(this.setDatabaseSettings(this.client.getDatabase(this.databaseName), config), collectionName, input, dropCollection);
    }

    public InputStream createFile(MongoConfig config, InputStream content, String filename, InputStream metadata) {
        return this.fileService.createFile(this.client.getDatabase(this.databaseName), config, content, filename, metadata);
    }

    public List<TypedValue<InputStream>> findFiles(MongoConfig config, InputStream query, InputStream sort, StreamingHelper streamingHelper) {
        return this.fileService.findFiles(this.client.getDatabase(this.databaseName), config, query, sort, streamingHelper);
    }

    public Result<TypedValue<Object>, TypedValue<InputStream>> getFileContent(MongoConfig config, InputStream fileId, StreamingHelper streamingHelper) {
        return this.fileService.getFileContent(this.client.getDatabase(this.databaseName), config, fileId, streamingHelper);
    }

    public void removeFiles(MongoConfig config, InputStream fileId) {
        this.fileService.removeFiles(this.client.getDatabase(this.databaseName), config, fileId);
    }

    private MongoDatabase setDatabaseSettings(MongoDatabase database, MongoConfig config) {
        MongoDatabase newDatabase = database;
        switch (config.getReadPreference()) {
            case PRIMARY: {
                newDatabase = newDatabase.withReadPreference(ReadPreference.primary());
                break;
            }
            case PRIMARY_PREFERED: {
                newDatabase = newDatabase.withReadPreference((ReadPreference)ReadPreference.primaryPreferred(this.convertToMongoTagset(config.getReadPreferenceTags()), (long)config.getMaximumStalenessSeconds(), (TimeUnit)TimeUnit.SECONDS));
                break;
            }
            case SECONDARY: {
                newDatabase = newDatabase.withReadPreference((ReadPreference)ReadPreference.secondary(this.convertToMongoTagset(config.getReadPreferenceTags()), (long)config.getMaximumStalenessSeconds(), (TimeUnit)TimeUnit.SECONDS));
                break;
            }
            case SECONDARY_PREFERRED: {
                newDatabase = newDatabase.withReadPreference((ReadPreference)ReadPreference.secondaryPreferred(this.convertToMongoTagset(config.getReadPreferenceTags()), (long)config.getMaximumStalenessSeconds(), (TimeUnit)TimeUnit.SECONDS));
                break;
            }
            case NEAREST: {
                newDatabase = newDatabase.withReadPreference((ReadPreference)ReadPreference.nearest(this.convertToMongoTagset(config.getReadPreferenceTags()), (long)config.getMaximumStalenessSeconds(), (TimeUnit)TimeUnit.SECONDS));
                break;
            }
        }
        if (config.getReadConcern() != null) {
            switch (config.getReadConcern()) {
                case LOCAL: {
                    newDatabase = newDatabase.withReadConcern(ReadConcern.LOCAL);
                    break;
                }
                case MAJORITY: {
                    newDatabase = newDatabase.withReadConcern(ReadConcern.MAJORITY);
                    break;
                }
                case SNAPSHOT: {
                    newDatabase = newDatabase.withReadConcern(ReadConcern.SNAPSHOT);
                    break;
                }
                case AVAILABLE: {
                    newDatabase = newDatabase.withReadConcern(ReadConcern.AVAILABLE);
                    break;
                }
                case LINEARIZABLE: {
                    newDatabase = newDatabase.withReadConcern(ReadConcern.LINEARIZABLE);
                    break;
                }
            }
        }
        if (!StringUtils.isEmpty((String)config.getWriteConcern().getWriteConcernAcknowledgement())) {
            newDatabase = config.getWriteConcern().getWriteConcernAcknowledgement().equals("majority") ? newDatabase.withWriteConcern(new WriteConcern((int)config.getWriteConcern().getWriteConcernTimeoutTimeunit().toMillis(config.getWriteConcern().getWriteConcernTimeout())).withW("majority")) : newDatabase.withWriteConcern(new WriteConcern(Integer.parseInt(config.getWriteConcern().getWriteConcernAcknowledgement()), (int)config.getWriteConcern().getWriteConcernTimeoutTimeunit().toMillis(config.getWriteConcern().getWriteConcernTimeout())));
        }
        return newDatabase;
    }

    private List<TagSet> convertToMongoTagset(List<ReadPreferenceTag> tags) {
        ArrayList<TagSet> mongoTagSets = new ArrayList<TagSet>();
        for (ReadPreferenceTag eachMap : tags) {
            for (Map.Entry<String, String> map : eachMap.getNameValue().entrySet()) {
                Tag tag = new Tag(map.getKey(), map.getValue());
                mongoTagSets.add(new TagSet(tag));
            }
        }
        return mongoTagSets;
    }
}

