/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connector.mongo.internal.connection;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.tls.TlsContextFactory;

public class MongoClientURIBuilder {
    private String connectionString;
    private TlsContextFactory tlsContextFactory;
    private boolean tlsEnabled;
    private MongoClientURI uri;

    public MongoClientURIBuilder withConnectionString(String connectionString) {
        this.connectionString = connectionString;
        this.uri = new MongoClientURI(connectionString);
        return this;
    }

    public MongoClient build() {
        if (this.tlsEnabled) {
            try {
                MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder().sslEnabled(true).sslContext(this.tlsContextFactory.createSslContext());
                this.uri = new MongoClientURI(this.connectionString, optionsBuilder);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return new MongoClient(this.uri);
    }

    public String getDatabase() {
        return this.uri.getDatabase();
    }

    public MongoClientURIBuilder withTlsContext(TlsContextFactory tlsContextFactory) throws ConnectionException {
        if (this.uri.getOptions().isSslEnabled()) {
            this.tlsEnabled = true;
            this.tlsContextFactory = Optional.ofNullable(tlsContextFactory).orElseGet(() -> TlsContextFactory.builder().buildDefault());
        }
        return this;
    }
}

