/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidURIException;

public class URIUtils {
    private URIUtils() {
    }

    public static URI getURI(String stringURI) {
        try {
            URL url = new URL(stringURI);
            return new URI(url.getProtocol(), url.getHost(), url.getPath(), url.getQuery(), null);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new InvalidURIException(stringURI, e);
        }
    }

    public static URI encodeQuery(String uri) throws URISyntaxException, MalformedURLException {
        URL url = new URL(uri);
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath());
        if (url.getQuery() != null) {
            String[] pairs;
            for (String pair : pairs = url.getQuery().split("&")) {
                if (!StringUtils.isNotBlank((String)pair)) continue;
                int idx = pair.indexOf("=");
                uriBuilder.addParameter(pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return uriBuilder.build();
    }
}

