/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.utils;

import com.fasterxml.jackson.core.JsonParseException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.apache.olingo.client.api.communication.ODataServerErrorException;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.commons.api.ex.ODataError;
import org.apache.olingo.commons.api.ex.ODataErrorDetail;
import org.apache.olingo.commons.api.ex.ODataRuntimeException;
import org.apache.olingo.commons.api.format.ContentType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ODataCheckResponse {
    SINGLETON;

    private static final Logger LOG;
    private static final String TEXT_CONTENT_TYPE = "text/plain";
    private static final String PARSING_ERROR = "Parsing error!";
    private static final String UNAUTHORIZED_ERROR = "UNAUTHORIZED";
    private static final String ERROR_DESERIALIZING_ERROR_RESPONSE = "Error deserializing error response";

    public void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        BasicHttpEntity basicHttpEntity = new BasicHttpEntity();
        InputStream backupInputStream = this.copyInputStreamFromResponse(response, basicHttpEntity);
        if (response == null) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Unexpected null response"));
        }
        if (response.getStatusLine().getStatusCode() >= 400) {
            Header contentTypeHeader = response.getEntity() != null ? response.getEntity().getContentType() : null;
            try {
                ODataRuntimeException exception = this.checkResponseInCaseOfError(odataClient, response.getStatusLine(), response.getEntity() == null ? null : response.getEntity().getContent(), contentTypeHeader != null && contentTypeHeader.getValue().contains(TEXT_CONTENT_TYPE) ? TEXT_CONTENT_TYPE : accept);
                if (!this.isExpectedParsingException((Exception)exception)) {
                    throw exception;
                }
            }
            catch (IOException e) {
                throw new ODataRuntimeException("Received '" + response.getStatusLine() + "' but could not extract error body", (Exception)e);
            }
        }
        if (response.getEntity() != null) {
            basicHttpEntity.setContent(backupInputStream);
            response.setEntity((HttpEntity)basicHttpEntity);
        }
    }

    private InputStream copyInputStreamFromResponse(HttpResponse response, BasicHttpEntity basicHttpEntity) {
        ByteArrayInputStream backupInputStream = null;
        try {
            if (response != null && response.getEntity() != null && response.getEntity().getContent() != null) {
                InputStream inputStream = response.getEntity().getContent();
                long origLength = response.getEntity().getContentLength();
                byte[] byteArray = IOUtils.toByteArray((InputStream)inputStream);
                backupInputStream = new ByteArrayInputStream(byteArray);
                EntityUtils.consume((HttpEntity)response.getEntity());
                basicHttpEntity.setContent((InputStream)new ByteArrayInputStream(byteArray));
                basicHttpEntity.setContentType(response.getEntity().getContentType());
                basicHttpEntity.setContentEncoding(response.getEntity().getContentEncoding());
                basicHttpEntity.setContentLength(origLength);
                response.setEntity((HttpEntity)basicHttpEntity);
            }
        }
        catch (IOException e) {
            LOG.info("Error when trying to consume the entity", (Throwable)e);
        }
        return backupInputStream;
    }

    private ODataRuntimeException checkResponseInCaseOfError(ODataClient odataClient, StatusLine statusLine, InputStream entity, String accept) {
        ODataClientErrorException result;
        if (statusLine.getStatusCode() == 401) {
            return new ODataClientErrorException(statusLine, this.getUnauthorizedError());
        }
        if (entity == null) {
            result = new ODataClientErrorException(statusLine);
        } else {
            ContentType contentType = accept.contains("xml") ? ContentType.APPLICATION_ATOM_XML : ContentType.JSON;
            ODataError error = new ODataError();
            error = !accept.contains(TEXT_CONTENT_TYPE) ? this.readODataError(odataClient, statusLine, entity, contentType) : this.enrichODataErrorFromText(statusLine, entity, error);
            result = !(statusLine.getStatusCode() < 500 || error == null || error.getDetails() != null && !error.getDetails().isEmpty() || error.getInnerError() != null && error.getInnerError().size() != 0) ? new ODataServerErrorException(statusLine) : new ODataClientErrorException(statusLine, error);
        }
        return result;
    }

    private ODataError readODataError(ODataClient odataClient, StatusLine statusLine, InputStream entity, ContentType contentType) {
        ODataError error;
        try {
            Map innerError;
            error = odataClient.getReader().readError(entity, contentType);
            if (error != null && (innerError = error.getInnerError()) != null) {
                if (innerError.get("internalexception") != null) {
                    error.setMessage(error.getMessage() + (String)innerError.get("internalexception"));
                } else {
                    error.setMessage(error.getMessage() + (String)innerError.get("message"));
                }
            }
        }
        catch (RuntimeException e) {
            LOG.debug(ERROR_DESERIALIZING_ERROR_RESPONSE, (Throwable)e);
            error = this.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        catch (ODataDeserializerException e) {
            error = e.getCause() instanceof JsonParseException ? this.getParsingError(statusLine.getStatusCode(), statusLine.getReasonPhrase(), e.getMessage()) : this.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            LOG.debug(ERROR_DESERIALIZING_ERROR_RESPONSE, (Throwable)e);
        }
        return error;
    }

    private ODataError enrichODataErrorFromText(StatusLine statusLine, InputStream entity, ODataError error) {
        error.setCode(String.valueOf(statusLine.getStatusCode()));
        error.setTarget(statusLine.getReasonPhrase());
        try {
            error.setMessage(IOUtils.toString((InputStream)entity));
        }
        catch (IOException e) {
            LOG.debug(ERROR_DESERIALIZING_ERROR_RESPONSE, (Throwable)e);
            error = this.getGenericError(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return error;
    }

    private ODataError getGenericError(int code, String errorMsg) {
        ODataError error = new ODataError();
        error.setCode(String.valueOf(code));
        error.setMessage(errorMsg);
        return error;
    }

    private ODataError getParsingError(int code, String statusLine, String errorMsg) {
        ODataError error = new ODataError();
        error.setCode(String.valueOf(code));
        error.setMessage(statusLine);
        ODataErrorDetail errorDetail = new ODataErrorDetail();
        errorDetail.setCode("500");
        errorDetail.setMessage(PARSING_ERROR + errorMsg);
        error.setDetails(Collections.singletonList(errorDetail));
        return error;
    }

    private ODataError getUnauthorizedError() {
        ODataError error = new ODataError();
        error.setCode("401");
        error.setMessage(UNAUTHORIZED_ERROR);
        ODataErrorDetail errorDetail = new ODataErrorDetail();
        errorDetail.setCode("401");
        errorDetail.setMessage(UNAUTHORIZED_ERROR);
        error.setDetails(Collections.singletonList(errorDetail));
        return error;
    }

    private boolean isExpectedParsingException(Exception e) {
        if (e instanceof ODataClientErrorException) {
            ODataError error = ((ODataClientErrorException)((Object)e)).getODataError();
            return error != null && error.getDetails() != null && ((ODataErrorDetail)error.getDetails().get(0)).getCode().equalsIgnoreCase("500") && ((ODataErrorDetail)error.getDetails().get(0)).getMessage().contains(PARSING_ERROR);
        }
        return false;
    }

    static {
        LOG = LoggerFactory.getLogger(ODataCheckResponse.class);
    }
}

