/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365Action;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ActionParameter;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ActionReturnType;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ComplexType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ActionMetadataHandler
extends DefaultHandler {
    private static final String ENTITY_TYPE = "EntityType";
    private static final String ACTION = "Action";
    private static final String PARAMETER = "Parameter";
    private static final String RETURN_TYPE = "ReturnType";
    private static final String NAME = "Name";
    private static final String TYPE = "Type";
    private static final String COMPLEX_TYPE = "ComplexType";
    private static final String NULLABLE = "Nullable";
    private static final String IS_BOUND = "IsBound";
    private static final String IS_ABTRACT = "Abstract";
    private static final String ENTITY_PARAM = "entity";
    private static final String PROPERTY = "Property";
    private static final String ENUM_TYPE = "EnumType";
    private static final String COLLECTION = "Collection(";
    private Map<String, Dynamics365Action> actions = new LinkedHashMap<String, Dynamics365Action>();
    private Map<String, String> enums = new LinkedHashMap<String, String>();
    private Map<String, Dynamics365ComplexType> complexTypes = new LinkedHashMap<String, Dynamics365ComplexType>();
    private Map<String, String> abstractEntityTypes = new HashMap<String, String>();
    private Dynamics365Action dynamicsAction = null;
    private Dynamics365ComplexType complexType = null;
    private Map<String, Dynamics365ActionParameter> actionParameters = null;
    private Map<String, Dynamics365ActionParameter> complexTypeProperties = null;
    private Dynamics365ActionReturnType returnType = null;
    private boolean complexTypesPropertiesBegin = false;

    public Map<String, Dynamics365Action> getActions() {
        return this.actions;
    }

    public Map<String, Dynamics365ComplexType> getComplexTypes() {
        return this.complexTypes;
    }

    public Map<String, String> getEnums() {
        return this.enums;
    }

    public Map<String, String> getAbstractEntityTypes() {
        return this.abstractEntityTypes;
    }

    @Override
    public void startElement(String uri, String localName, String elementName, Attributes attributes) throws SAXException {
        if (elementName.equals(ACTION)) {
            this.resetActionObjects();
            this.dynamicsAction.setName(attributes.getValue(NAME));
            this.dynamicsAction.setBound(Boolean.parseBoolean(attributes.getValue(IS_BOUND)));
        } else if (elementName.equals(ENTITY_TYPE)) {
            this.updateAbstractEntityTypes(attributes);
        } else if (elementName.equals(ENUM_TYPE)) {
            String enumName = attributes.getValue(NAME);
            this.enums.put(enumName, enumName);
        } else if (elementName.equals(COMPLEX_TYPE)) {
            this.resetComplexTypesObjects();
            this.complexType.setName(attributes.getValue(NAME));
        } else if (elementName.equals(PARAMETER)) {
            this.addParameter(this.actionParameters, attributes);
        } else if (this.complexTypesPropertiesBegin && elementName.equals(PROPERTY)) {
            this.addParameter(this.complexTypeProperties, attributes);
        } else if (elementName.equals(RETURN_TYPE)) {
            this.returnType = new Dynamics365ActionReturnType();
            this.returnType.setType(attributes.getValue(TYPE));
            this.returnType.setNullable(Boolean.parseBoolean(attributes.getValue(NULLABLE)));
            if (attributes.getValue(TYPE).contains(COLLECTION)) {
                this.returnType.setCollection(true);
            }
        }
    }

    private void updateAbstractEntityTypes(Attributes attributes) {
        Boolean isAbstract = Boolean.parseBoolean(attributes.getValue(IS_ABTRACT));
        if (isAbstract != null && isAbstract.booleanValue()) {
            String entityTypeName = attributes.getValue(NAME);
            this.abstractEntityTypes.put(entityTypeName, entityTypeName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String elementName) throws SAXException {
        if (!elementName.equals(ACTION)) {
            if (elementName.equals(COMPLEX_TYPE)) {
                this.complexType.setProperties(this.complexTypeProperties);
                this.complexTypesPropertiesBegin = false;
                this.complexTypes.put(this.complexType.getName(), this.complexType);
            }
        } else {
            this.dynamicsAction.setParameters(this.actionParameters);
            this.dynamicsAction.setReturnType(this.returnType);
            Dynamics365ActionParameter entityParam = this.actionParameters.get(ENTITY_PARAM);
            String actionName = entityParam == null ? this.dynamicsAction.getName() : String.format(this.dynamicsAction.getName(), " for ", entityParam.getType());
            this.actions.put(actionName, this.dynamicsAction);
        }
    }

    @Override
    public void characters(char[] ac, int i, int j) throws SAXException {
    }

    private void addParameter(Map<String, Dynamics365ActionParameter> paramMap, Attributes attributes) {
        Dynamics365ActionParameter param = new Dynamics365ActionParameter();
        param.setName(attributes.getValue(NAME));
        String type = attributes.getValue(TYPE).replace("mscrm.", "");
        boolean isCollecton = type.contains(COLLECTION);
        if (isCollecton) {
            type = type.replace(COLLECTION, "");
            type = type.replace(")", "");
            param.setCollection(true);
        }
        param.setType(type);
        param.setNullable(Boolean.parseBoolean(attributes.getValue(NULLABLE)));
        paramMap.put(param.getName(), param);
    }

    private void resetActionObjects() {
        this.dynamicsAction = new Dynamics365Action();
        this.actionParameters = new LinkedHashMap<String, Dynamics365ActionParameter>();
        this.returnType = null;
    }

    private void resetComplexTypesObjects() {
        this.complexTypesPropertiesBegin = true;
        this.complexType = new Dynamics365ComplexType();
        this.complexTypeProperties = new LinkedHashMap<String, Dynamics365ActionParameter>();
    }
}

