/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.source;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.extension.microsoftdynamics365.internal.config.Dynamics365Configuration;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.Dynamics365ErrorType;
import org.mule.extension.microsoftdynamics365.internal.error.exception.Dynamics365Exception;
import org.mule.extension.microsoftdynamics365.internal.metadata.OnDeletedObjectSourceMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.operation.DynamicsQueryPagingDelegate;
import org.mule.extension.microsoftdynamics365.internal.operation.RawEntitiesResponse;
import org.mule.extension.microsoftdynamics365.internal.operation.util.OperationUtil;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

@Alias(value="on-deleted-object-listener", description="Listener for deleted objects.")
@MetadataScope(outputResolver=OnDeletedObjectSourceMetadataResolver.class, keysResolver=OnDeletedObjectSourceMetadataResolver.class)
public class OnDeletedObjectSource
extends PollingSource<Map<String, Object>, Serializable> {
    @Parameter
    @MetadataKeyId
    private String entityType;
    @Config
    protected Dynamics365Configuration config;
    @Connection
    private ConnectionProvider<Dynamics365Connection> connectionProvider;
    protected Dynamics365Connection connection;
    private static final String MISSING_DELTA_LINK_ERROR_MESSAGE = "Delta link not available. Verify the feature is enabled in the instance.";
    private final Map<String, String> additionalHeaders = Collections.singletonMap("Prefer", "odata.track-changes,odata.maxpagesize=5000");
    private String deltaLink;

    protected void doStart() throws MuleException {
        this.connection = (Dynamics365Connection)this.connectionProvider.connect();
        String retrieveDeletedEntitiesURI = this.createRetrieveDeletedEntitiesURI(this.entityType);
        DynamicsQueryPagingDelegate pagingDelegate = new DynamicsQueryPagingDelegate(retrieveDeletedEntitiesURI, this.additionalHeaders, null);
        RawEntitiesResponse pageOfDeletedEntities = pagingDelegate.getRawPage(this.connection);
        while (pageOfDeletedEntities.getResults().size() > 0) {
            if (pageOfDeletedEntities.getDeltaLink() != null) {
                this.deltaLink = pageOfDeletedEntities.getDeltaLink();
            }
            pageOfDeletedEntities = pagingDelegate.getRawPage(this.connection);
        }
        if (StringUtils.isEmpty((String)this.deltaLink)) {
            throw new Dynamics365Exception(MISSING_DELTA_LINK_ERROR_MESSAGE, Dynamics365ErrorType.NOT_FOUND);
        }
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        try {
            DynamicsQueryPagingDelegate pagingDelegate = new DynamicsQueryPagingDelegate(this.deltaLink, this.additionalHeaders, null);
            RawEntitiesResponse pageOfChangedObjects = pagingDelegate.getRawPage(this.connection);
            List<Map<String, Object>> changedObjects = pageOfChangedObjects.getResults();
            List<Map> deletedObjects = Collections.EMPTY_LIST;
            while (changedObjects.size() > 0) {
                Predicate<Map> areDeleted = changedObject -> changedObject.get("reason") != null && String.valueOf(changedObject.get("reason")).equalsIgnoreCase("deleted");
                deletedObjects = changedObjects.stream().filter(areDeleted).collect(Collectors.toList());
                if (pageOfChangedObjects.getDeltaLink() != null) {
                    this.deltaLink = pageOfChangedObjects.getDeltaLink();
                }
                pageOfChangedObjects = pagingDelegate.getRawPage(this.connection);
                changedObjects = pageOfChangedObjects.getResults();
            }
            deletedObjects.forEach(deletedObject -> pollContext.accept(item -> item.setResult(this.toResult((Map<String, Object>)deletedObject)).setWatermark((Serializable)((Object)this.deltaLink)).setId(this.getId((Map<String, Object>)deletedObject))));
        }
        catch (ModuleException e) {
            Optional hasConnectionException = ExceptionUtils.extractCauseOfType((Throwable)e, ConnectionException.class);
            if (e.getType().equals((Object)Dynamics365ErrorType.CONNECTIVITY) && hasConnectionException.isPresent()) {
                pollContext.onConnectionException(new ConnectionException((Throwable)hasConnectionException.get(), (Object)this.connection));
            }
            throw e;
        }
        catch (AccessTokenExpiredException e) {
            pollContext.onConnectionException(new ConnectionException((Throwable)e, (Object)this.connection));
        }
    }

    private String createRetrieveDeletedEntitiesURI(String entityType) {
        String apiEndpoint = this.connection.getApiEndpoint();
        String entitySetName = OperationUtil.getEntitySetNameByLogicalName(entityType, this.connection);
        return apiEndpoint + entitySetName;
    }

    private Result<Map<String, Object>, Serializable> toResult(Map<String, Object> entity) {
        return Result.builder().output(entity).build();
    }

    private String getId(Map<String, Object> entity) {
        return (String)entity.get("id");
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext callbackContext) {
    }
}

