/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.source;

import java.io.Serializable;
import java.net.URISyntaxException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.microsoftdynamics365.internal.config.Dynamics365Configuration;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.Dynamics365ErrorType;
import org.mule.extension.microsoftdynamics365.internal.metadata.RetrieveEntitiesByQueryMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.operation.Dynamics365StandardOperations;
import org.mule.extension.microsoftdynamics365.internal.operation.util.OperationUtil;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectTrigger
extends PollingSource<Map<String, Object>, Serializable> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractObjectTrigger.class);
    protected static final DateTimeFormatter MULE_DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
    private static final int ITEMS_PER_PAGE = 2500;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Summary(value="The required date format is 'yyyy-MM-dd'T'HH:mm:ss'Z'")
    protected String since;
    @Parameter
    @MetadataKeyId(value=RetrieveEntitiesByQueryMetadataResolver.class)
    private String entityType;
    protected LocalDateTime actualDate;
    @Config
    protected Dynamics365Configuration config;
    @Connection
    protected ConnectionProvider<Dynamics365Connection> connectionProvider;
    protected Dynamics365Connection connection;

    protected void doStart() throws MuleException {
        this.connection = (Dynamics365Connection)this.connectionProvider.connect();
        try {
            this.actualDate = this.since == null || this.since.isEmpty() ? LocalDateTime.now(ZoneOffset.UTC) : LocalDateTime.parse(this.since, MULE_DATETIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new DefaultMuleException("Invalid date format. The required format is 'yyyy-MM-dd'T'HH:mm:ss'Z'", (Throwable)e);
        }
    }

    protected void doStop() {
        this.connectionProvider.disconnect((Object)this.connection);
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext sourceCallbackContext) {
    }

    protected abstract String getWatermarkField();

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        try {
            this.retrieveEntities(pollContext, this.entityType);
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (ModuleException e) {
            Optional hasConnectionException = ExceptionUtils.extractCauseOfType((Throwable)e, ConnectionException.class);
            if (e.getType().equals((Object)Dynamics365ErrorType.CONNECTIVITY) && hasConnectionException.isPresent()) {
                pollContext.onConnectionException(new ConnectionException((Throwable)hasConnectionException.get(), (Object)this.connection));
            }
            throw e;
        }
        catch (AccessTokenExpiredException e) {
            pollContext.onConnectionException(new ConnectionException((Throwable)e, (Object)this.connection));
        }
    }

    protected void retrieveEntities(PollContext<Map<String, Object>, Serializable> pollContext, String entityType) throws URISyntaxException {
        String retrieveURI = this.createRetrieveURI(pollContext, entityType);
        Dynamics365StandardOperations standardOperations = new Dynamics365StandardOperations();
        PagingProvider<Dynamics365Connection, Map<String, Object>> pagingDelegate = standardOperations.retrieveMultiple(retrieveURI, 2500);
        List currentPage = pagingDelegate.getPage((Object)this.connection);
        while (currentPage.size() > 0) {
            currentPage.forEach(entity -> pollContext.accept(item -> item.setResult(this.toResult((Map<String, Object>)entity)).setWatermark(this.extractWatermark((Map<String, Object>)entity)).setId(this.getId((Map<String, Object>)entity, entityType))));
            currentPage = pagingDelegate.getPage((Object)this.connection);
        }
    }

    protected Result<Map<String, Object>, Serializable> toResult(Map<String, Object> entity) {
        return Result.builder().output(entity).build();
    }

    protected Serializable extractWatermark(Map<String, Object> entity) {
        return LocalDateTime.parse(String.valueOf(entity.get(this.getWatermarkField())), MULE_DATETIME_FORMAT);
    }

    protected String getId(Map<String, Object> entity, String entityType) {
        return (String)entity.get(entityType + "id");
    }

    private String createRetrieveURI(PollContext<Map<String, Object>, Serializable> pollContext, String entityType) {
        Optional watermarkValue = pollContext.getWatermark();
        if (watermarkValue.isPresent()) {
            this.actualDate = (LocalDateTime)watermarkValue.get();
        }
        String apiEndpoint = this.connection.getApiEndpoint();
        String watermarkField = this.getWatermarkField();
        String entitySetName = OperationUtil.getEntitySetNameByLogicalName(entityType, this.connection);
        String dataQueryURL = entitySetName + "?$select=*";
        String dataQueryOrder = "&$orderby=" + watermarkField + " asc";
        String dataQueryFilter = "&$filter=" + watermarkField + " gt ";
        String date = this.actualDate.toString() + "Z";
        StringBuilder uri = new StringBuilder(apiEndpoint).append(dataQueryURL).append(dataQueryOrder).append(dataQueryFilter).append(date);
        return uri.toString();
    }
}

