/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.query;

import java.util.List;
import org.mule.extension.microsoftdynamics365.internal.query.DSQLtoOdataOperatorTranslator;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.extension.api.dsql.Direction;
import org.mule.runtime.extension.api.dsql.EntityType;
import org.mule.runtime.extension.api.dsql.Field;
import org.mule.runtime.extension.api.dsql.OperatorTranslator;
import org.mule.runtime.extension.api.dsql.QueryTranslator;
import org.mule.runtime.extension.api.dsql.Value;

public class DynamicsQueryTranslator
implements QueryTranslator {
    StringBuilder translation = new StringBuilder("");
    private static final String SELECT_ALL = "*";
    private static final String QUESTION_MARK = "?";
    private static final String COMMA = ",";
    private static final String EMPTY_SPACE = " ";
    private static final String LIKE = " like ";
    private static final String CONTAINS = "contains";
    private boolean isSelectAll = false;
    private boolean useAnd = false;

    public void translateFields(List<Field> list) {
        this.isSelectAll = list.size() == 1 && list.get(0).getName().equals(SELECT_ALL);
        StringBuilder selectFields = null;
        if (!this.isSelectAll) {
            selectFields = new StringBuilder("$select=");
            for (int i = 0; i < list.size(); ++i) {
                Field field = list.get(i);
                selectFields.append(field.getName());
                if (i == list.size() - 1) continue;
                selectFields.append(COMMA);
            }
            this.useAnd = true;
        }
        this.translation.append((CharSequence)selectFields);
    }

    public void translateTypes(EntityType entityType) {
        try {
            this.translation.insert(0, QUESTION_MARK);
            this.translation.insert(0, entityType.getName());
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), (Throwable)e);
        }
    }

    public void translateOrderByFields(List<Field> orderByFields, Direction direction) {
        StringBuilder orderBy = new StringBuilder(this.useAnd ? "&$orderby=" : "$orderby=");
        if (!orderByFields.isEmpty()) {
            String directionString = EMPTY_SPACE + direction.name().toLowerCase();
            for (Field orderByField : orderByFields) {
                orderBy.append(orderByField.getName()).append(directionString);
            }
            this.translation.append((CharSequence)orderBy);
            this.useAnd = true;
        }
    }

    public void translateAnd() {
        this.translation.append(" and ");
    }

    public void translateOR() {
        this.translation.append(" or ");
    }

    public void translateComparison(String operator, Field field, Value<?> value) {
        String name = this.addQuotesIfNeeded(field.getName());
        if (operator.equals(LIKE)) {
            this.translation.append(CONTAINS).append("(").append(name).append(COMMA).append(value.toString()).append(")");
        } else {
            this.translation.append(name).append(operator).append(value.toString());
        }
    }

    public void translateBeginExpression() {
        String filterBy = this.useAnd ? "&$filter=" : "$filter=";
        this.translation.append(filterBy);
        this.useAnd = true;
    }

    public void translateInitPrecedence() {
        this.translation.append("(");
    }

    public void translateEndPrecedence() {
        this.translation.append(")");
    }

    public void translateLimit(int limit) {
        String top;
        String string = top = this.useAnd ? "&$top=" : "$top=";
        if (limit > 0) {
            this.translation.append(top).append(limit);
        }
    }

    public void translateOffset(int i) {
    }

    public String getTranslation() {
        return this.translation.toString();
    }

    public OperatorTranslator operatorTranslator() {
        return new DSQLtoOdataOperatorTranslator();
    }

    private String addQuotesIfNeeded(String name) {
        return name.contains(EMPTY_SPACE) ? "'" + name + "'" : name;
    }
}

