/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation.util;

import java.io.InputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.ODataBasicRequest;
import org.apache.olingo.client.api.communication.request.ODataBatchableRequest;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.api.domain.ClientCollectionValue;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientObjectFactory;
import org.apache.olingo.client.api.domain.ClientPrimitiveValue;
import org.apache.olingo.client.api.domain.ClientProperty;
import org.apache.olingo.client.api.domain.ClientValue;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.odata2.api.client.batch.BatchSingleResponse;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkItem;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.DynamicsBulkResult;
import org.mule.extension.microsoftdynamics365.internal.connection.dto.ErrorResponse;
import org.mule.extension.microsoftdynamics365.internal.error.exception.LogicalNameNotFoundException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.MissingKeyException;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataEntityCreateRequest;
import org.mule.runtime.api.bulk.BulkItem;
import org.mule.runtime.api.bulk.BulkOperationResult;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;

public class OperationUtil {
    public static final String CUSTOM_ENTITY_KEY = "entityId";
    public static final String CUSTOM_ATTRIBUTES_KEY = "attributes";
    private static final String ENTITY_SET_NAME = "EntitySetName";
    private static final String DATE_FORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    private static final String DATETIME_FORMAT_YYYY_MM_DD_T_HH_MM_SS = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String EDM_DATETIME_OFFSET_SUFFIX = "Z";
    private static Map<String, String> entitySetNameByLogicalNameCache = new HashMap<String, String>();

    private OperationUtil() {
    }

    public static String getEntitySetNameByLogicalName(String entityLogicalName, Dynamics365Connection connection) {
        String cacheValue = entitySetNameByLogicalNameCache.get(entityLogicalName);
        if (cacheValue != null) {
            return cacheValue;
        }
        String entitySetName = Optional.ofNullable(connection.get(String.format("EntityDefinitions(LogicalName='%s')/", entityLogicalName)).get(ENTITY_SET_NAME)).map(String.class::cast).filter(StringUtils::isNotEmpty).orElseThrow(() -> new LogicalNameNotFoundException(entityLogicalName));
        entitySetNameByLogicalNameCache.put(entityLogicalName, entitySetName);
        return entitySetName;
    }

    public static <T extends ODataBasicRequest> void addHeadersToRequest(String encoding, T request) {
        ContentType contentType = ContentType.create((ContentType)ContentType.JSON_NO_METADATA, (String)"IEEE754Compatible", (String)"true");
        String formatString = contentType.toContentTypeString();
        request.setAccept(formatString);
        request.setContentType(formatString + ";" + "charset" + "=" + encoding);
    }

    public static ClientEntity getClientEntity(ClientObjectFactory objectFactory, Map<String, Object> attributes) {
        ClientEntity entity = objectFactory.newEntity(null);
        if (MapUtils.isEmpty(attributes)) {
            return entity;
        }
        attributes.entrySet().forEach(entry -> entity.getProperties().add(OperationUtil.getClientProperty(objectFactory, entry)));
        return entity;
    }

    private static ClientProperty getClientProperty(ClientObjectFactory objectFactory, Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof List) {
            return OperationUtil.getComplexProperty(objectFactory, entry.getKey(), (List)entry.getValue());
        }
        ClientPrimitiveValue value = OperationUtil.getPrimitiveValue(objectFactory, entry.getValue());
        return objectFactory.newPrimitiveProperty(entry.getKey(), value);
    }

    private static ClientProperty getComplexProperty(ClientObjectFactory objectFactory, String name, List<Object> list) {
        ClientCollectionValue clientCollectionValue = objectFactory.newCollectionValue(name);
        ClientProperty clientProperty = objectFactory.newCollectionProperty(name, clientCollectionValue);
        for (Object element : list) {
            if (element instanceof Map) {
                Map map = (Map)element;
                clientCollectionValue.add((ClientValue)OperationUtil.getComplexValue(objectFactory, map));
                continue;
            }
            clientCollectionValue.add((ClientValue)OperationUtil.getPrimitiveValue(objectFactory, element));
        }
        return clientProperty;
    }

    private static ClientComplexValue getComplexValue(ClientObjectFactory objectFactory, Map<String, Object> nestedEntityProperty) {
        ClientComplexValue clientComplexValue = objectFactory.newComplexValue(null);
        nestedEntityProperty.entrySet().forEach(nestedEntry -> clientComplexValue.add(OperationUtil.getClientProperty(objectFactory, nestedEntry)));
        return clientComplexValue;
    }

    private static ClientPrimitiveValue getPrimitiveValue(ClientObjectFactory objectFactory, Object value) {
        Object returnedValue = value;
        if (value instanceof Date) {
            returnedValue = new SimpleDateFormat(DATE_FORMAT_YYYY_MM_DD).format(value);
        } else if (value instanceof GregorianCalendar) {
            returnedValue = new SimpleDateFormat(DATETIME_FORMAT_YYYY_MM_DD_T_HH_MM_SS).format(((GregorianCalendar)value).getTime()) + EDM_DATETIME_OFFSET_SUFFIX;
        }
        return objectFactory.newPrimitiveValueBuilder().setValue(returnedValue).build();
    }

    public static String parseEntityIdFromURI(String uri) {
        return uri.substring(uri.indexOf("(") + 1, uri.indexOf(")"));
    }

    public static String getEntityIdHeaderValue(ODataResponse response) {
        return Optional.ofNullable(response.getHeader("OData-EntityId")).map(Object::toString).orElse(null);
    }

    public static String getEntityIdHeaderValue(BatchSingleResponse response) {
        return Optional.ofNullable(response.getHeader("OData-EntityId")).map(Object::toString).orElse(null);
    }

    public static <T> BulkOperationResult<T> computeBulkOperationResult(DynamicsBulkResult<T> dynamicsResult) {
        BulkOperationResult.BulkOperationResultBuilder builder = BulkOperationResult.builder();
        for (DynamicsBulkItem<T> dynamicsItem : dynamicsResult.getItems()) {
            BulkItem.BulkItemBuilder bulkItemBuilder = BulkItem.builder();
            bulkItemBuilder.setSuccessful(dynamicsItem.isSuccessful());
            bulkItemBuilder.setPayload(dynamicsItem.getPayload());
            bulkItemBuilder.setStatusCode(dynamicsItem.getStatusCode());
            bulkItemBuilder.setRecordId(dynamicsItem.getId());
            bulkItemBuilder.setMessage(dynamicsItem.getMessage());
            if (dynamicsItem.getException() != null) {
                bulkItemBuilder.setException(dynamicsItem.getException());
            }
            builder.addItem(bulkItemBuilder);
        }
        return builder.build();
    }

    public static ODataBatchableRequest createEntityForBatchRequest(ODataClient client, URI uri, Map<String, Object> entityAttributes, String encoding) {
        ClientObjectFactory objectFactory = client.getObjectFactory();
        ClientEntity entity = OperationUtil.getClientEntity(objectFactory, entityAttributes);
        DynamicsODataEntityCreateRequest<ClientEntity> request = new DynamicsODataEntityCreateRequest<ClientEntity>(client, uri, entity);
        OperationUtil.addHeadersToRequest(encoding, request);
        return request;
    }

    public static <T> DynamicsBulkItem.BulkItemBuilder<T> getBulkItem(ODataResponse item, T payload) {
        InputStream odataRawResponse;
        String entityHeaderValue = OperationUtil.getEntityIdHeaderValue(item);
        String message = item.getStatusMessage();
        String statusCode = String.valueOf(item.getStatusCode());
        String exceptionMessage = null;
        if (Integer.parseInt(statusCode) >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode() && (odataRawResponse = item.getRawResponse()) != null) {
            exceptionMessage = IOUtils.toString((InputStream)odataRawResponse);
        }
        return OperationUtil.getBulkItemBuilder(item, payload, entityHeaderValue, message, statusCode, exceptionMessage);
    }

    private static <T> DynamicsBulkItem.BulkItemBuilder<T> getBulkItemBuilder(Object item, T payload, String entityHeaderValue, String message, String statusCode, String exceptionMessage) {
        boolean isSuccessful = true;
        if (item instanceof ErrorResponse || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entityHeaderValue)) {
            isSuccessful = false;
        }
        DynamicsBulkItem.BulkItemBuilder<T> bulkItemBuilder = DynamicsBulkItem.builder();
        bulkItemBuilder.setSuccessful(isSuccessful);
        bulkItemBuilder.setPayload(payload);
        bulkItemBuilder.setStatusCode(statusCode);
        if (!org.mule.runtime.core.api.util.StringUtils.isEmpty((String)exceptionMessage)) {
            bulkItemBuilder.setException(new Exception(exceptionMessage));
        }
        if (isSuccessful) {
            bulkItemBuilder.setRecordId(UUID.fromString(OperationUtil.parseEntityIdFromURI(entityHeaderValue)));
        } else {
            bulkItemBuilder.setMessage(message);
        }
        return bulkItemBuilder;
    }

    public static <T> DynamicsBulkItem.BulkItemBuilder<T> getBulkItem(BatchSingleResponse item, T payload) {
        String entityHeaderValue = OperationUtil.getEntityIdHeaderValue(item);
        String message = item.getBody();
        String statusCode = item.getStatusCode();
        String exceptionMessage = null;
        if (Integer.parseInt(statusCode) >= HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode()) {
            exceptionMessage = message;
        }
        return OperationUtil.getBulkItemBuilder(item, payload, entityHeaderValue, message, statusCode, exceptionMessage);
    }

    public static <T> DynamicsBulkItem.BulkItemBuilder<T> getDefaultBulkItem(T payload) {
        String unprocessedErrorMsg = "Request UNPROCESSED";
        DynamicsBulkItem.BulkItemBuilder<T> bulkItemBuilder = DynamicsBulkItem.builder();
        bulkItemBuilder.setSuccessful(false);
        bulkItemBuilder.setPayload(payload);
        bulkItemBuilder.setStatusCode(String.valueOf(HttpStatusCodes.BAD_REQUEST.getStatusCode()));
        bulkItemBuilder.setMessage(unprocessedErrorMsg);
        bulkItemBuilder.setException(new Exception(unprocessedErrorMsg));
        return bulkItemBuilder;
    }

    public static <T> T validateAttributes(Map<String, Object> entityDetails, Class<T> clazz) {
        return (T)Optional.ofNullable(entityDetails.get(CUSTOM_ATTRIBUTES_KEY)).map(clazz::cast).orElseThrow(() -> new MissingKeyException(CUSTOM_ATTRIBUTES_KEY));
    }

    public static String extractEntityId(Map<String, Object> attributes) {
        return Optional.of(attributes.get(CUSTOM_ENTITY_KEY)).map(String.class::cast).filter(StringUtils::isNotBlank).orElseThrow(() -> new MissingKeyException(CUSTOM_ENTITY_KEY));
    }

    public static ODataBatchableRequest deleteEntityForBatchRequest(ODataClient oDataClient, String apiEndpoint, String entitySetName, String entityId) {
        return oDataClient.getCUDRequestFactory().getDeleteRequest(oDataClient.newURIBuilder(apiEndpoint).appendEntitySetSegment(entitySetName).appendKeySegment((Object)UUID.fromString(entityId)).build());
    }
}

