/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation.odata;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.retrieve.ODataRawRequest;
import org.apache.olingo.client.api.communication.response.ODataRawResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataRequest;
import org.apache.olingo.client.core.communication.request.retrieve.ODataRawRequestImpl;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.commons.api.format.ContentType;
import org.mule.extension.microsoftdynamics365.internal.utils.ODataCheckResponse;

public class DynamicsODataRawRequestProxy
extends AbstractODataRequest
implements ODataRawRequest {
    private ODataRawRequest oDataRawRequest;

    public DynamicsODataRawRequestProxy(ODataRawRequest oDataRawRequest, ODataClient odataClient) {
        super(odataClient, oDataRawRequest.getMethod(), oDataRawRequest.getURI());
        this.oDataRawRequest = oDataRawRequest;
    }

    public void setFormat(String format) {
        this.oDataRawRequest.setFormat(format);
    }

    public ODataRawResponse execute() {
        return new DynamicsODataRawResponse(this.odataClient, this.httpClient, this.doExecute());
    }

    protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        ODataCheckResponse.SINGLETON.checkResponse(odataClient, response, accept);
    }

    public ContentType getDefaultFormat() {
        if (this.oDataRawRequest instanceof ODataRawRequestImpl) {
            return ((ODataRawRequestImpl)this.oDataRawRequest).getDefaultFormat();
        }
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    private class DynamicsODataRawResponse
    extends AbstractODataResponse
    implements ODataRawResponse {
        private byte[] obj;

        private DynamicsODataRawResponse(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.obj = null;
        }

        public <T> ResWrap<T> getBodyAs(Class<T> reference) {
            if (this.obj == null) {
                try {
                    this.obj = IOUtils.toByteArray((InputStream)this.getRawResponse());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            try {
                return this.odataClient.getReader().read((InputStream)new ByteArrayInputStream(this.obj), this.getContentType(), reference);
            }
            catch (ODataDeserializerException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

