/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation.odata;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityUpdateRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityUpdateResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataEntityCreateRequest;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataWriterImpl;
import org.mule.extension.microsoftdynamics365.internal.utils.ODataCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicsODataEntityUpdateRequest<E extends ClientEntity>
extends AbstractODataBasicRequest<ODataEntityUpdateResponse<E>>
implements ODataEntityUpdateRequest<E> {
    private static final Logger logger = LoggerFactory.getLogger(DynamicsODataEntityCreateRequest.class);
    private final E changes;

    public DynamicsODataEntityUpdateRequest(ODataClient odataClient, HttpMethod method, URI uri, E changes) {
        super(odataClient, method, uri);
        this.changes = changes;
    }

    protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        ODataCheckResponse.SINGLETON.checkResponse(odataClient, response, accept);
    }

    public InputStream getPayload() {
        try {
            DynamicsODataWriterImpl oDataWriter = new DynamicsODataWriterImpl(this.odataClient);
            InputStream inputStream = oDataWriter.writeEntity((ClientEntity)this.changes, ContentType.parse((String)this.getContentType()));
            return inputStream;
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataEntityUpdateResponse<E> execute() {
        InputStream input = this.getPayload();
        ((HttpEntityEnclosingRequestBase)this.request).setEntity(URIUtils.buildInputStreamEntity((ODataClient)this.odataClient, (InputStream)input));
        try {
            HttpResponse httpResponse = this.doExecute();
            ODataEntityUpdateResponseImpl response = new ODataEntityUpdateResponseImpl(this.odataClient, this.httpClient, httpResponse);
            if (httpResponse.getStatusLine().getStatusCode() == 204) {
                response.close();
            }
            logger.info("Execution of Update Request completed");
            ODataEntityUpdateResponseImpl oDataEntityUpdateResponseImpl = response;
            return oDataEntityUpdateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    private class ODataEntityUpdateResponseImpl
    extends AbstractODataResponse
    implements ODataEntityUpdateResponse<E> {
        private E entity;

        private ODataEntityUpdateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.entity = null;
        }

        public E getBody() {
            if (this.entity == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ContentType.parse((String)DynamicsODataEntityUpdateRequest.this.getAccept())).toEntity(this.getRawResponse());
                    this.entity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.entity;
        }
    }
}

