/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation.odata;

import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.olingo.client.api.ODataClient;
import org.apache.olingo.client.api.communication.request.cud.ODataEntityCreateRequest;
import org.apache.olingo.client.api.communication.response.ODataEntityCreateResponse;
import org.apache.olingo.client.api.data.ResWrap;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.serialization.ODataDeserializerException;
import org.apache.olingo.client.api.serialization.ODataSerializerException;
import org.apache.olingo.client.core.communication.request.AbstractODataBasicRequest;
import org.apache.olingo.client.core.communication.response.AbstractODataResponse;
import org.apache.olingo.client.core.uri.URIUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.mule.extension.microsoftdynamics365.internal.operation.odata.DynamicsODataWriterImpl;
import org.mule.extension.microsoftdynamics365.internal.utils.ODataCheckResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicsODataEntityCreateRequest<E extends ClientEntity>
extends AbstractODataBasicRequest<ODataEntityCreateResponse<E>>
implements ODataEntityCreateRequest<E> {
    private static final Logger logger = LoggerFactory.getLogger(DynamicsODataEntityCreateRequest.class);
    private final E entity;

    public DynamicsODataEntityCreateRequest(ODataClient odataClient, URI targetURI, E entity) {
        super(odataClient, HttpMethod.POST, targetURI);
        this.entity = entity;
    }

    public InputStream getPayload() {
        try {
            DynamicsODataWriterImpl oDataWriter = new DynamicsODataWriterImpl(this.odataClient);
            InputStream inputStream = oDataWriter.writeEntity((ClientEntity)this.entity, ContentType.parse((String)this.getContentType()));
            return inputStream;
        }
        catch (ODataSerializerException e) {
            throw new IllegalArgumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataEntityCreateResponse<E> execute() {
        InputStream input = this.getPayload();
        ((HttpPost)this.request).setEntity(URIUtils.buildInputStreamEntity((ODataClient)this.odataClient, (InputStream)input));
        try {
            ODataEntityCreateResponseImpl response = new ODataEntityCreateResponseImpl(this.odataClient, this.httpClient, this.doExecute());
            logger.info("Execution of Create Request completed");
            ODataEntityCreateResponseImpl oDataEntityCreateResponseImpl = response;
            return oDataEntityCreateResponseImpl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    protected void checkResponse(ODataClient odataClient, HttpResponse response, String accept) {
        ODataCheckResponse.SINGLETON.checkResponse(odataClient, response, accept);
    }

    public ContentType getDefaultFormat() {
        return this.odataClient.getConfiguration().getDefaultPubFormat();
    }

    private class ODataEntityCreateResponseImpl
    extends AbstractODataResponse
    implements ODataEntityCreateResponse<E> {
        private E resEntity;

        private ODataEntityCreateResponseImpl(ODataClient odataClient, HttpClient httpClient, HttpResponse res) {
            super(odataClient, httpClient, res);
            this.resEntity = null;
        }

        public E getBody() {
            if (this.resEntity == null) {
                try {
                    ResWrap resource = this.odataClient.getDeserializer(ContentType.parse((String)DynamicsODataEntityCreateRequest.this.getAccept())).toEntity(this.getRawResponse());
                    this.resEntity = this.odataClient.getBinder().getODataEntity(resource);
                }
                catch (ODataDeserializerException e) {
                    throw new IllegalArgumentException(e);
                }
                finally {
                    this.close();
                }
            }
            return this.resEntity;
        }
    }
}

