/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.exception.InvalidURIException;
import org.mule.extension.microsoftdynamics365.internal.operation.RawEntitiesResponse;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicsQueryPagingDelegate
implements PagingProvider<Dynamics365Connection, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger(DynamicsQueryPagingDelegate.class);
    private String retrieveURI;
    private boolean isFirstQuery = true;
    private Map<String, String> additionalHeaders;
    private String expand;
    private String skipToken;
    private URI encodedURI;

    public DynamicsQueryPagingDelegate(String retrieveURI, Map<String, String> additionalHeaders, String expand) {
        this.retrieveURI = retrieveURI;
        this.additionalHeaders = additionalHeaders;
        this.expand = expand;
    }

    public List<Map<String, Object>> getPage(Dynamics365Connection connection) {
        return this.getRawPage(connection).getResults();
    }

    public RawEntitiesResponse getRawPage(Dynamics365Connection connection) {
        return connection.execute(() -> {
            logger.debug("Requesting new page");
            if (this.retrieveURI == null) {
                logger.debug("Next query is null - do not retrieve more pages.");
                return new RawEntitiesResponse();
            }
            try {
                this.retrieveURI = this.retrieveURI.startsWith("http") ? this.retrieveURI : connection.getApiEndpoint() + this.retrieveURI;
                URI uri = this.encodedURI = this.isFirstQuery ? this.getURI(this.retrieveURI) : this.encodedURI;
                if (!this.isFirstQuery && this.skipToken != null) {
                    uri = new URIBuilder(this.encodedURI).addParameter("$skiptoken", this.skipToken).build();
                }
                uri = this.addExpand(uri);
                Map<String, Object> entitiesResponse = connection.rawRetrieve(uri, this.additionalHeaders);
                RawEntitiesResponse response = new RawEntitiesResponse();
                response.setResults((List)entitiesResponse.get("value"));
                response.setDeltaLink(String.valueOf(entitiesResponse.get("@odata.deltaLink")));
                this.prepareNextPage(entitiesResponse);
                this.isFirstQuery = false;
                return response;
            }
            catch (UnsupportedEncodingException | MalformedURLException | URISyntaxException e) {
                throw new InvalidURIException(this.retrieveURI, e);
            }
        });
    }

    private void prepareNextPage(Map<String, Object> entitiesResponse) throws UnsupportedEncodingException {
        if (entitiesResponse.get("@odata.nextLink") != null) {
            String decodedURL = URLDecoder.decode(entitiesResponse.get("@odata.nextLink").toString(), StandardCharsets.UTF_8.toString());
            this.skipToken = decodedURL.substring(decodedURL.indexOf("$skiptoken=") + "$skiptoken=".length());
        } else {
            this.skipToken = null;
            this.retrieveURI = null;
        }
    }

    private URI addExpand(URI uri) {
        if (this.expand != null) {
            URIBuilder uriBuilder = new URIBuilder(uri);
            uriBuilder.addParameter("$expand", this.expand);
            try {
                uri = uriBuilder.build();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return uri;
    }

    public Optional<Integer> getTotalResults(Dynamics365Connection connection) {
        return Optional.of(-1);
    }

    public void close(Dynamics365Connection connection) {
        logger.debug("Nothing has to be done in order to close pagination.");
    }

    private URI getURI(String retrieveURI) throws MalformedURLException, URISyntaxException {
        URL url = new URL(retrieveURI);
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(url.getProtocol()).setHost(url.getHost()).setPath(url.getPath());
        if (url.getQuery() != null) {
            String[] pairs;
            for (String pair : pairs = url.getQuery().split("&\\$(?=(?:[^']*'[^']*')*[^']*$)")) {
                if (!StringUtils.isNotBlank((String)pair)) continue;
                int idx = pair.indexOf("=");
                if (pair.startsWith("$")) {
                    uriBuilder.addParameter(pair.substring(0, idx), pair.substring(idx + 1));
                    continue;
                }
                uriBuilder.addParameter("$" + pair.substring(0, idx), pair.substring(idx + 1));
            }
        }
        return uriBuilder.build();
    }
}

