/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.operation;

import java.util.Collections;
import java.util.Map;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.exception.MaxPageSizeExceededException;
import org.mule.extension.microsoftdynamics365.internal.error.provider.Dynamics365ErrorTypeProvider;
import org.mule.extension.microsoftdynamics365.internal.metadata.CreateEntityMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.metadata.DeleteEntityMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.metadata.RetrieveEntitiesByQueryMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.metadata.RetrieveEntityMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.metadata.UpdateEntityMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.operation.DynamicsQueryPagingDelegate;
import org.mule.extension.microsoftdynamics365.internal.query.DynamicsQueryTranslator;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.display.Text;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public class Dynamics365StandardOperations {
    @Throws(value={Dynamics365ErrorTypeProvider.class})
    @MediaType(value="*/*")
    public String create(@Connection Dynamics365Connection connection, @MetadataKeyId(value=CreateEntityMetadataResolver.class) String logicalName, @Content @TypeResolver(value=CreateEntityMetadataResolver.class) Map<String, Object> attributes, @ConfigOverride @Optional @Placement(tab="Advanced", order=1) @Summary(value="The default body encoding for requests.") @Example(value="UTF-8") String encoding) {
        return connection.createEntity(logicalName, attributes, encoding);
    }

    @Throws(value={Dynamics365ErrorTypeProvider.class})
    public void delete(@Connection Dynamics365Connection connection, @MetadataKeyId(value=DeleteEntityMetadataResolver.class) String logicalName, @Content @TypeResolver(value=DeleteEntityMetadataResolver.class) String id) {
        connection.deleteEntity(logicalName, id);
    }

    @Throws(value={Dynamics365ErrorTypeProvider.class})
    @OutputResolver(output=RetrieveEntityMetadataResolver.class)
    public Map<String, Object> retrieve(@Connection Dynamics365Connection connection, @MetadataKeyId(value=RetrieveEntityMetadataResolver.class) String logicalName, @Content String id) {
        return connection.retrieve(logicalName, id);
    }

    @Throws(value={Dynamics365ErrorTypeProvider.class})
    public void update(@Connection Dynamics365Connection connection, @MetadataKeyId(value=UpdateEntityMetadataResolver.class) String logicalName, @Content @TypeResolver(value=UpdateEntityMetadataResolver.class) Map<String, Object> attributes, @ConfigOverride @Optional @Placement(tab="Advanced", order=1) @Summary(value="The default body encoding for requests.") @Example(value="UTF-8") String encoding) {
        connection.updateEntity(logicalName, attributes, encoding);
    }

    @OutputResolver(output=RetrieveEntityMetadataResolver.class)
    @Throws(value={Dynamics365ErrorTypeProvider.class})
    public PagingProvider<Dynamics365Connection, Map<String, Object>> retrieveMultiple(@DisplayName(value="Data Query URL") @Text String dataQueryURL, @Optional(defaultValue="5000") int pageSize) {
        Map<String, String> additionalHeaders = null;
        if (pageSize > 0) {
            if (pageSize > 5000) {
                throw new MaxPageSizeExceededException();
            }
            additionalHeaders = Collections.singletonMap("Prefer", "odata.maxpagesize=" + pageSize);
        }
        return new DynamicsQueryPagingDelegate(dataQueryURL, additionalHeaders, null);
    }

    @Throws(value={Dynamics365ErrorTypeProvider.class})
    @Query(entityResolver=RetrieveEntitiesByQueryMetadataResolver.class, nativeOutputResolver=RetrieveEntitiesByQueryMetadataResolver.class, translator=DynamicsQueryTranslator.class)
    public PagingProvider<Dynamics365Connection, Map<String, Object>> retrieveMultipleByQuery(@DisplayName(value="Datasense Query") @Text @MetadataKeyId(value=RetrieveEntitiesByQueryMetadataResolver.class) String query, @Optional(defaultValue="5000") int pageSize, @Optional String expand) {
        Map<String, String> additionalHeaders = null;
        if (pageSize > 0) {
            if (pageSize > 5000) {
                throw new MaxPageSizeExceededException();
            }
            additionalHeaders = Collections.singletonMap("Prefer", "odata.maxpagesize=" + pageSize);
        }
        return new DynamicsQueryPagingDelegate(query, additionalHeaders, expand);
    }
}

