/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.metadata;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.mule.extension.microsoftdynamics365.internal.config.Dynamics365Configuration;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.metadata.AbstractEntityMetadataResolver;
import org.mule.extension.microsoftdynamics365.internal.utils.ActionMetadataHandler;
import org.mule.extension.microsoftdynamics365.internal.utils.EntityProperty;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365Action;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ActionParameter;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ActionReturnType;
import org.mule.extension.microsoftdynamics365.internal.utils.rest.Dynamics365ComplexType;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DoActionMetadataResolver
extends AbstractEntityMetadataResolver
implements InputTypeResolver<String>,
OutputTypeResolver<String>,
TypeKeysResolver {
    public String getResolverName() {
        return DoActionMetadataResolver.class.getName();
    }

    public MetadataType getOutputType(MetadataContext metadataContext, String metadataKey) throws ConnectionException, MetadataResolvingException {
        ActionMetadataHandler metadataHandler = this.getActionMetadataHandler(metadataContext);
        ObjectTypeBuilder metadataBuilder = metadataContext.getTypeBuilder().objectType().id(metadataKey);
        Dynamics365Action action = metadataHandler.getActions().get(metadataKey);
        Dynamics365ActionReturnType actionReturnType = action.getReturnType();
        if (actionReturnType == null) {
            return metadataBuilder.addField().key(metadataKey).label(metadataKey).value().tupleType().of().objectType().build();
        }
        String parameterType = this.extractParameterType(actionReturnType);
        boolean isEnumType = metadataHandler.getEnums().containsKey(parameterType);
        boolean isAbstractType = metadataHandler.getAbstractEntityTypes().get(parameterType) != null;
        boolean isCollection = actionReturnType.isCollection();
        if (parameterType != null && (parameterType.contains("Edm.") || isEnumType)) {
            this.addSimpleType(metadataBuilder, isCollection, parameterType, parameterType);
        } else if (metadataHandler.getComplexTypes().containsKey(parameterType)) {
            this.addComplexType(metadataBuilder, metadataContext, metadataHandler, parameterType, parameterType, isCollection);
        } else if (isAbstractType) {
            this.addAbstractType(metadataBuilder, isCollection, parameterType);
        } else {
            this.addEntityField(metadataBuilder, metadataContext, actionReturnType);
        }
        return metadataBuilder.build();
    }

    private String extractParameterType(Dynamics365ActionReturnType actionReturnType) {
        String parameterType = null;
        if (actionReturnType.getType().startsWith("mscrm.")) {
            parameterType = actionReturnType.getType().substring(6);
        } else if (actionReturnType.isCollection()) {
            parameterType = actionReturnType.getType().substring(actionReturnType.getType().lastIndexOf(".") + 1, actionReturnType.getType().lastIndexOf(")"));
        }
        return parameterType;
    }

    public MetadataType getInputMetadata(MetadataContext metadataContext, String metadataKey) throws MetadataResolvingException, ConnectionException {
        ActionMetadataHandler metadataHandler = this.getActionMetadataHandler(metadataContext);
        Dynamics365Action action = metadataHandler.getActions().get(metadataKey);
        ObjectTypeBuilder metadataBuilder = metadataContext.getTypeBuilder().objectType().id(metadataKey);
        for (Map.Entry<String, Dynamics365ActionParameter> entry : action.getParameters().entrySet()) {
            Dynamics365ActionParameter parameter = entry.getValue();
            String parameterName = parameter.getName();
            String parameterType = parameter.getType();
            if (parameterName.equals("entity")) continue;
            boolean isEnumType = metadataHandler.getEnums().containsKey(parameterType);
            boolean isAbstractType = metadataHandler.getAbstractEntityTypes().get(parameterType) != null;
            boolean isCollection = parameter.isCollection();
            if (parameterType.contains("Edm.") || isEnumType) {
                this.addSimpleType(metadataBuilder, isCollection, parameterName, parameterType);
                continue;
            }
            if (metadataHandler.getComplexTypes().containsKey(parameterType)) {
                this.addComplexType(metadataBuilder, metadataContext, metadataHandler, parameterName, parameterType, isCollection);
                continue;
            }
            if (isAbstractType) {
                this.addAbstractType(metadataBuilder, isCollection, parameterName);
                continue;
            }
            this.addEntityField(metadataBuilder, metadataContext, parameter);
        }
        return metadataBuilder.build();
    }

    @Override
    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        return this.getActionMetadataHandler(metadataContext).getActions().entrySet().stream().map(entry -> MetadataKeyBuilder.newKey((String)((String)entry.getKey())).build()).collect(Collectors.toSet());
    }

    public String getCategoryName() {
        return DoActionMetadataResolver.class.getSimpleName();
    }

    private void addSimpleType(ObjectTypeBuilder metadataBuilder, boolean isCollection, String parameterName, String parameterType) {
        if (isCollection) {
            this.addSimpleField(metadataBuilder, "List", parameterName);
        } else {
            this.addSimpleField(metadataBuilder, parameterType, parameterName);
        }
    }

    private void addComplexType(ObjectTypeBuilder metadataBuilder, MetadataContext metadataContext, ActionMetadataHandler metadataHandler, String parameterName, String parameterType, boolean isCollection) throws ConnectionException, MetadataResolvingException {
        MetadataType complexTypeMetadataModel = this.addComplexEntityField(metadataContext, metadataHandler.getComplexTypes().get(parameterType), metadataHandler);
        if (isCollection) {
            metadataBuilder.addField().label(parameterName).key(parameterName).value().arrayType().of(complexTypeMetadataModel);
        } else {
            metadataBuilder.addField().label(parameterName).key(parameterName).value(complexTypeMetadataModel);
        }
    }

    private MetadataType addComplexEntityField(MetadataContext metadataContext, Dynamics365ComplexType dynamics365ComplexType, ActionMetadataHandler metadataHandler) throws ConnectionException, MetadataResolvingException {
        ObjectTypeBuilder metadataBuilder = metadataContext.getTypeBuilder().objectType();
        for (Map.Entry<String, Dynamics365ActionParameter> entryProperty : dynamics365ComplexType.getProperties().entrySet()) {
            boolean isAbstractType;
            Dynamics365ActionParameter property = entryProperty.getValue();
            String parameterName = property.getName();
            String parameterType = property.getType();
            boolean isCollection = property.isCollection();
            boolean isEnumType = metadataHandler.getEnums().containsKey(parameterType);
            boolean bl = isAbstractType = metadataHandler.getAbstractEntityTypes().get(parameterType) != null;
            if (parameterType.contains("Edm.") || isEnumType) {
                this.addSimpleType(metadataBuilder, isCollection, parameterName, parameterType);
                continue;
            }
            if (metadataHandler.getComplexTypes().containsKey(parameterType)) {
                this.addComplexTypeRecursively(metadataHandler, parameterType, dynamics365ComplexType, metadataBuilder, metadataContext, isCollection, parameterName);
                continue;
            }
            if (isAbstractType) {
                this.addAbstractType(metadataBuilder, isCollection, parameterName);
                continue;
            }
            this.addEntityField(metadataBuilder, metadataContext, property);
        }
        return metadataBuilder.build();
    }

    private void addComplexTypeRecursively(ActionMetadataHandler metadataHandler, String parameterType, Dynamics365ComplexType dynamics365ComplexType, ObjectTypeBuilder metadataBuilder, MetadataContext metadataContext, boolean isCollection, String parameterName) throws ConnectionException, MetadataResolvingException {
        if (parameterType.equals(dynamics365ComplexType.getName())) {
            this.addAbstractType(metadataBuilder, isCollection, parameterName);
        } else {
            MetadataType metadataModel = this.addComplexEntityField(metadataContext, metadataHandler.getComplexTypes().get(parameterType), metadataHandler);
            if (isCollection) {
                metadataBuilder.addField().label(parameterName).key(parameterName).value().arrayType().of(metadataModel);
            } else {
                metadataBuilder.addField().label(parameterName).key(parameterName).value(metadataModel);
            }
        }
    }

    private void addAbstractType(ObjectTypeBuilder metadataBuilder, boolean isCollection, String parameterName) {
        if (isCollection) {
            metadataBuilder.addField().label(parameterName).key(parameterName).value().arrayType().of().objectType();
        } else {
            metadataBuilder.addField().label(parameterName).key(parameterName).value().objectType();
        }
    }

    private void addEntityField(ObjectTypeBuilder metadataBuilder, MetadataContext metadataContext, Dynamics365ActionParameter parameter) throws ConnectionException, MetadataResolvingException {
        MetadataType complexField = parameter.isCollection() ? this.getListEntityAttributes(parameter.getType(), metadataContext, EntityProperty.IS_VALID_FOR_CREATE) : this.getEntityAttributes(parameter.getType(), parameter.getName(), metadataContext, EntityProperty.IS_VALID_FOR_CREATE);
        metadataBuilder.addField().label(parameter.getName()).key(parameter.getName()).value(complexField);
    }

    private void addEntityField(ObjectTypeBuilder metadataBuilder, MetadataContext metadataContext, Dynamics365ActionReturnType parameter) throws ConnectionException, MetadataResolvingException {
        String parameterType = parameter.getType().substring(6);
        MetadataType complexField = parameter.isCollection() ? this.getListEntityAttributes(parameterType, metadataContext, EntityProperty.IS_VALID_FOR_CREATE) : this.getEntityAttributes(parameterType, parameterType, metadataContext, EntityProperty.IS_VALID_FOR_CREATE);
        metadataBuilder.addField().label(parameterType).key(parameterType).value(complexField);
    }

    private ActionMetadataHandler getActionMetadataHandler(MetadataContext metadataContext) throws ConnectionException, MetadataResolvingException {
        try {
            ActionMetadataHandler actionHandler = new ActionMetadataHandler();
            Dynamics365Connection connection = (Dynamics365Connection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException("No connection available.", FailureCode.CONNECTION_FAILURE));
            Dynamics365Configuration configuration = (Dynamics365Configuration)metadataContext.getConfig().orElseThrow(() -> new MetadataResolvingException("No configuration available.", FailureCode.INVALID_CONFIGURATION));
            InputSource inputSource = new InputSource(new StringReader((String)String.class.cast(connection.getMetadata(configuration.getEncoding()).get("body"))));
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            SAXParser saxParser = saxParserFactory.newSAXParser();
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            saxParser.parse(inputSource, (DefaultHandler)actionHandler);
            return actionHandler;
        }
        catch (ParserConfigurationException e) {
            throw new MetadataResolvingException("Failed to parse metadata.", FailureCode.INVALID_CONFIGURATION, (Throwable)e);
        }
        catch (IOException | SAXException e) {
            throw new MetadataResolvingException("Failed to parse metadata.", FailureCode.UNKNOWN, (Throwable)e);
        }
    }
}

