/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.utils.EntityProperty;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;

public class AbstractEntityMetadataResolver {
    protected static final String BIND = "@odata.bind";
    protected static final String VALUE_KEY = "value";
    protected static final String LOGICAL_NAME = "LogicalName";
    protected static final String ENTITY_SET_NAME = "EntitySetName";
    protected static final String ATTRIBUTE_OF = "AttributeOf";
    protected static final String ATTRIBUTE_TYPE = "AttributeType";
    protected static final String TARGETS = "Targets";
    protected static final int MULTIPLE_TARGET_MIN_SIZE = 2;
    private static final String NO_CONNECTION_AVAILABLE = "No connection available.";

    public MetadataType getEntityAttributes(String entityKey, String metadataId, MetadataContext metadataContext, EntityProperty isValidForOperation) throws ConnectionException, MetadataResolvingException {
        ObjectTypeBuilder typeBuilder = metadataContext.getTypeBuilder().objectType().id(metadataId);
        Dynamics365Connection connection = (Dynamics365Connection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException(NO_CONNECTION_AVAILABLE, FailureCode.CONNECTION_FAILURE));
        Map<String, Object> entityAttributesResponse = connection.getEntityAttributesByLogicalName(entityKey);
        List values = (List)entityAttributesResponse.get(VALUE_KEY);
        if (values != null) {
            for (LinkedHashMap value2 : values) {
                this.addMetadataField(typeBuilder, value2, isValidForOperation);
            }
        }
        if (values != null) {
            values.stream().filter(value -> value.get(ATTRIBUTE_TYPE).toString().equals("DateTime")).collect(Collectors.toList());
        }
        return typeBuilder.build();
    }

    protected void addMetadataField(ObjectTypeBuilder objectTypeBuilder, Map<String, Object> value, EntityProperty operation) {
        String logicalName = (String)value.get(LOGICAL_NAME);
        String attributeOf = (String)value.get(ATTRIBUTE_OF);
        String attributeType = (String)value.get(ATTRIBUTE_TYPE);
        Object targets = value.get(TARGETS);
        Boolean isValidForOperation = (Boolean)value.get(operation.toString());
        if (targets == null) {
            if (Boolean.TRUE.equals(isValidForOperation) && StringUtils.isNotBlank((CharSequence)logicalName) && attributeOf == null) {
                this.addSimpleField(objectTypeBuilder, attributeType, logicalName);
            }
        } else {
            this.addTarget(objectTypeBuilder, targets, logicalName, isValidForOperation, operation);
        }
    }

    private void addTarget(ObjectTypeBuilder objectTypeBuilder, Object targets, String logicalName, Boolean isValidForOperation, EntityProperty operation) {
        if (!operation.equals((Object)EntityProperty.IS_VALID_FOR_SELECT) && Boolean.TRUE.equals(isValidForOperation)) {
            List targetList = (List)targets;
            if (targetList.size() >= 2) {
                for (String target : targetList) {
                    objectTypeBuilder.addField().label(logicalName + "_" + target + BIND).key(logicalName + "_" + target + BIND).value().stringType();
                }
            } else {
                objectTypeBuilder.addField().label(logicalName + BIND).key(logicalName + BIND).value().stringType();
            }
        } else if (operation.equals((Object)EntityProperty.IS_VALID_FOR_SELECT)) {
            objectTypeBuilder.addField().label("_" + logicalName + "_" + VALUE_KEY).key("_" + logicalName + "_" + VALUE_KEY).value().stringType();
        }
    }

    public void addSimpleField(ObjectTypeBuilder objectTypeBuilder, String attributeType, String logicalName) {
        switch (attributeType) {
            case "String": 
            case "Edm.String": 
            case "EntityName": 
            case "Memo": 
            case "Uniqueidentifier": 
            case "Edm.Guid": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().stringType();
                break;
            }
            case "Double": 
            case "Integer": 
            case "Decimal": 
            case "BigInt": 
            case "Money": 
            case "Edm.Decimal": 
            case "Edm.Double": 
            case "Edm.Int32": 
            case "Edm.Int64": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().numberType();
                break;
            }
            case "DateTime": 
            case "Edm.DateTime": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().dateTimeType();
                break;
            }
            case "Boolean": 
            case "Edm.Boolean": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().booleanType();
                break;
            }
            case "List": {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().arrayType().of().stringType();
                break;
            }
            default: {
                objectTypeBuilder.addField().key(logicalName).label(logicalName).value().anyType();
            }
        }
    }

    public MetadataType getListEntityAttributes(String entityKey, MetadataContext metadataContext, EntityProperty isValidForOperation) throws ConnectionException, MetadataResolvingException {
        ObjectTypeBuilder typeBuilder = metadataContext.getTypeBuilder().arrayType().of().objectType().id(entityKey);
        Dynamics365Connection connection = (Dynamics365Connection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException(NO_CONNECTION_AVAILABLE, FailureCode.CONNECTION_FAILURE));
        Map<String, Object> entityAttributesResponse = connection.getEntityAttributesByLogicalName(entityKey);
        List values = (List)entityAttributesResponse.get(VALUE_KEY);
        if (values != null) {
            for (LinkedHashMap value : values) {
                this.addMetadataField(typeBuilder, value, isValidForOperation);
            }
        }
        return typeBuilder.build();
    }

    public MetadataType getInputMetadataForUpdate(MetadataContext metadataContext, String entityId) throws ConnectionException, MetadataResolvingException {
        Dynamics365Connection connection = (Dynamics365Connection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException(NO_CONNECTION_AVAILABLE, FailureCode.CONNECTION_FAILURE));
        ObjectTypeBuilder typeBuilder = metadataContext.getTypeBuilder().arrayType().of().objectType().id(entityId);
        this.addSimpleField(typeBuilder, String.class.getSimpleName(), "entityId");
        ObjectTypeBuilder secondLevel = typeBuilder.addField().label("attributes").key("attributes").value().objectType();
        Map<String, Object> entityAttributesResponse = connection.getEntityAttributesByLogicalName(entityId);
        List values = (List)entityAttributesResponse.get(VALUE_KEY);
        if (CollectionUtils.isNotEmpty((Collection)values)) {
            for (LinkedHashMap value : values) {
                this.addMetadataField(secondLevel, value, EntityProperty.IS_VALID_FOR_UPDATE);
            }
        }
        secondLevel.build();
        return typeBuilder.build();
    }

    public MetadataType getInputMetadataForDisassociate(MetadataContext metadataContext, String entityId) {
        ObjectTypeBuilder typeBuilder = metadataContext.getTypeBuilder().objectType().id(entityId);
        this.addSimpleField(typeBuilder, String.class.getSimpleName(), "entityId");
        this.addSimpleField(typeBuilder, List.class.getSimpleName(), "attributes");
        return typeBuilder.build();
    }

    public Set<MetadataKey> getKeys(MetadataContext metadataContext) throws MetadataResolvingException, ConnectionException {
        Dynamics365Connection connection = (Dynamics365Connection)metadataContext.getConnection().orElseThrow(() -> new MetadataResolvingException(NO_CONNECTION_AVAILABLE, FailureCode.CONNECTION_FAILURE));
        return Optional.ofNullable((List)connection.getEntityTypes().get(VALUE_KEY)).orElseGet(ArrayList::new).stream().flatMap(value -> value.entrySet().stream()).filter(entry -> ((String)entry.getKey()).equals(LOGICAL_NAME)).map(entry -> MetadataKeyBuilder.newKey((String)((String)String.class.cast(entry.getValue()))).withDisplayName((String)String.class.cast(entry.getValue())).build()).collect(Collectors.toSet());
    }
}

