/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.error.exception.handlers;

import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.Dynamics365ErrorType;
import org.mule.extension.microsoftdynamics365.internal.error.exception.EntityNotFoundException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.ForbiddenException;
import org.mule.extension.microsoftdynamics365.internal.error.exception.OperationFailedException;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ODataClientErrorExceptionHandler {
    public ModuleException handle(ODataClientErrorException exception, Dynamics365Connection connection) {
        switch (exception.getStatusLine().getStatusCode()) {
            case 401: {
                connection.onAccessTokenExpiredException();
                return new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)exception));
            }
            case 403: {
                return new ForbiddenException(exception);
            }
            case 404: {
                return new EntityNotFoundException(exception);
            }
        }
        return new OperationFailedException(exception);
    }
}

