/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.microsoftdynamics365.internal.error.exception.handlers;

import java.net.SocketTimeoutException;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.olingo.client.api.communication.ODataClientErrorException;
import org.mule.extension.microsoftdynamics365.internal.connection.Dynamics365Connection;
import org.mule.extension.microsoftdynamics365.internal.error.Dynamics365ErrorType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class HttpClientExceptionHandler {
    public ModuleException handle(Exception exception, Dynamics365Connection connection) {
        String exceptionMessage = exception.getMessage();
        Optional extractedException = ExceptionUtils.extractOfType((Throwable)exception, ODataClientErrorException.class);
        if (extractedException.isPresent()) {
            ODataClientErrorException cause = (ODataClientErrorException)((Object)extractedException.get());
            if (cause.getODataError().getCode().equals("401")) {
                connection.onAccessTokenExpiredException();
                throw new ModuleException((ErrorTypeDefinition)Dynamics365ErrorType.CONNECTIVITY, (Throwable)new ConnectionException((Throwable)exception));
            }
        } else if (ExceptionUtils.extractOfType((Throwable)exception, SocketTimeoutException.class).isPresent() || ExceptionUtils.extractOfType((Throwable)exception, TimeoutException.class).isPresent()) {
            return new ModuleException(StringUtils.isBlank((String)exceptionMessage) ? "Timeout error occurred!" : exception.getMessage(), (ErrorTypeDefinition)Dynamics365ErrorType.TIMEOUT, (Throwable)exception);
        }
        return new ModuleException(StringUtils.isBlank((String)exceptionMessage) ? "Unknown error occurred!" : exceptionMessage, (ErrorTypeDefinition)Dynamics365ErrorType.OPERATION_FAILED, (Throwable)exception);
    }
}

